/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.service.impl;

import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicMetaDaoHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicMetaDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicPageDto;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviTopicMetaMapper;
import com.huawei.support.icscbb.hwics.common.navi.service.IcsNaviTopicMetaService;
import com.huawei.support.icscbb.hwics.common.navi.util.IcsNaviUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsNaviTopicMetaServiceHandler
implements IcsNaviTopicMetaService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsNaviTopicMetaServiceHandler.class);
    private static final IcsNaviTopicMetaMapper ICS_NAVI_TOPIC_META_MAPPER = (IcsNaviTopicMetaMapper)DbMapperUtils.getMapper(IcsNaviTopicMetaMapper.class);

    private IcsNaviTopicMetaServiceHandler() {
    }

    public static IcsNaviTopicMetaServiceHandler getInstance() {
        return IcsNaviTopicMetaHandlerHolder.INSTANCE;
    }

    @Override
    public int init(List<IcsTopicMetaDo> topicMetaDtos) {
        if (CollectionUtils.isEmpty(topicMetaDtos)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "topiMetaList is null when init naviTopicMeta.");
            return 30100011;
        }
        IcsNaviTopicMetaDaoHandler.addNaviTopicMetas(ICS_NAVI_TOPIC_META_MAPPER, topicMetaDtos);
        return 30100010;
    }

    @Override
    public int deleteByDocId(String docId) {
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "docId is null when delete naviTopicMeta.");
            return 30100021;
        }
        IcsNaviTopicMetaDaoHandler.deleteNaviTopicMetas(ICS_NAVI_TOPIC_META_MAPPER, docId);
        return 30100020;
    }

    @Override
    public void deleteAll() {
        IcsNaviTopicMetaDaoHandler.deleteAll(ICS_NAVI_TOPIC_META_MAPPER);
    }

    @Override
    public List<IcsTopicMetaDo> getTopicMetaList(String docId, String pidId) {
        ArrayList<IcsTopicMetaDo> topicMetas = new ArrayList<IcsTopicMetaDo>();
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{docId, pidId})) {
            return topicMetas;
        }
        return IcsNaviTopicMetaDaoHandler.getTopicMetaList(ICS_NAVI_TOPIC_META_MAPPER, docId, pidId);
    }

    @Override
    public IcsTopicDo getTopicByDocId(String docId, String topicId) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{docId, topicId})) {
            return null;
        }
        return IcsNaviTopicMetaDaoHandler.getTopicByDocId(ICS_NAVI_TOPIC_META_MAPPER, docId, topicId);
    }

    @Override
    public IcsTopicPageDto getTopicMetasByPage(String docId, Integer pageNo, Integer pageSize) {
        IcsTopicPageDto pageDto = null;
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "hdxFileId can not be blank.");
            return pageDto;
        }
        int naviTopicsCount = IcsNaviTopicMetaDaoHandler.getTopicsCount(ICS_NAVI_TOPIC_META_MAPPER, docId);
        pageDto = IcsNaviUtil.getPage(pageNo, pageSize, naviTopicsCount);
        if (pageDto == null) {
            return pageDto;
        }
        pageDto.setDocId(docId);
        List<IcsTopicMetaDo> naviTopics = IcsNaviTopicMetaDaoHandler.getTopicsByPage(ICS_NAVI_TOPIC_META_MAPPER, pageDto);
        if (CollectionUtils.isEmpty(naviTopics)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "no naviTopics get.");
            return null;
        }
        pageDto.setDatas(naviTopics);
        return pageDto;
    }

    @Override
    public IcsTopicMetaDo getTopicByTopicUrl(String docId, String topicUrl) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{docId, topicUrl})) {
            return null;
        }
        return IcsNaviTopicMetaDaoHandler.getTopicByTopicUrl(ICS_NAVI_TOPIC_META_MAPPER, docId, topicUrl);
    }

    private static class IcsNaviTopicMetaHandlerHolder {
        private static final IcsNaviTopicMetaServiceHandler INSTANCE = new IcsNaviTopicMetaServiceHandler();

        private IcsNaviTopicMetaHandlerHolder() {
        }
    }
}

