/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.service.impl;

import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicMetaDao;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicMetaDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicPageDto;
import com.huawei.support.icscbb.hwics.common.navi.service.IcsNaviTopicMetaService;
import com.huawei.support.icscbb.hwics.common.navi.util.IcsNaviUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IcsNaviTopicMetaServiceImpl
implements IcsNaviTopicMetaService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsNaviTopicMetaServiceImpl.class);
    @Autowired
    private IcsNaviTopicMetaDao naviTopicMetaDao;

    @Override
    public int init(List<IcsTopicMetaDo> topicMetaDtos) {
        if (CollectionUtils.isEmpty(topicMetaDtos)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "topiMetaList is null when init naviTopicMeta.");
            return 30100011;
        }
        this.naviTopicMetaDao.addNaviTopicMetas(topicMetaDtos);
        return 30100010;
    }

    @Override
    public int deleteByDocId(String docId) {
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "docId is null when delete naviTopicMeta.");
            return 30100021;
        }
        int topicsCount = this.naviTopicMetaDao.getTopicsCount(docId);
        int times = topicsCount / 1000;
        for (int i = 0; i <= times; ++i) {
            this.naviTopicMetaDao.deleteNaviTopicMetas(docId);
        }
        return 30100020;
    }

    @Override
    public void deleteAll() {
    }

    @Override
    public List<IcsTopicMetaDo> getTopicMetaList(String docId, String pidId) {
        ArrayList<IcsTopicMetaDo> topicMetas = new ArrayList<IcsTopicMetaDo>();
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{docId, pidId})) {
            return topicMetas;
        }
        return this.naviTopicMetaDao.getTopicMetaList(docId, pidId);
    }

    @Override
    public IcsTopicDo getTopicByDocId(String docId, String topicId) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{docId, topicId})) {
            return null;
        }
        return this.naviTopicMetaDao.getTopicByDocId(docId, topicId);
    }

    @Override
    public IcsTopicPageDto getTopicMetasByPage(String docId, Integer pageNo, Integer pageSize) {
        IcsTopicPageDto pageDto = null;
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "hdxFileId can not be blank.");
            return pageDto;
        }
        int naviTopicsCount = this.naviTopicMetaDao.getTopicsCount(docId);
        pageDto = IcsNaviUtil.getPage(pageNo, pageSize, naviTopicsCount);
        if (pageDto == null) {
            return pageDto;
        }
        pageDto.setDocId(docId);
        List<IcsTopicMetaDo> naviTopics = this.naviTopicMetaDao.getTopicsByPage(pageDto);
        if (CollectionUtils.isEmpty(naviTopics)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "no naviTopics get.");
            return null;
        }
        pageDto.setDatas(naviTopics);
        return pageDto;
    }

    @Override
    public IcsTopicMetaDo getTopicByTopicUrl(String docId, String topicUrl) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{docId, topicUrl})) {
            return null;
        }
        return this.naviTopicMetaDao.getTopicByTopicUrl(docId, topicUrl);
    }
}

