/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.service.impl;

import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicRelationDaoHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicRelationDo;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviTopicRelationMapper;
import com.huawei.support.icscbb.hwics.common.navi.service.IcsNaviTopicRelationService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsNaviTopicRelationServiceHandler
implements IcsNaviTopicRelationService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsNaviTopicRelationServiceHandler.class);
    private static final IcsNaviTopicRelationMapper ICS_TOPICRELATION_MAPPER = (IcsNaviTopicRelationMapper)DbMapperUtils.getMapper(IcsNaviTopicRelationMapper.class);

    private IcsNaviTopicRelationServiceHandler() {
    }

    public static IcsNaviTopicRelationServiceHandler getInstance() {
        return IcsNaviTopicRelationHandlerHolder.INSTANCE;
    }

    @Override
    public int init(List<IcsTopicRelationDo> topicRelationDtos) {
        if (CollectionUtils.isEmpty(topicRelationDtos)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "RelationList is null when init naviTopicRelation.");
            return 30100011;
        }
        IcsNaviTopicRelationDaoHandler.addNaviTopicRelations(ICS_TOPICRELATION_MAPPER, topicRelationDtos);
        return 30100010;
    }

    @Override
    public int deleteByDocId(String docId) {
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "docId is null when delete naviTopicRelation.");
            return 30100021;
        }
        IcsNaviTopicRelationDaoHandler.deleteNaviTopicRelations(ICS_TOPICRELATION_MAPPER, docId);
        return 30100020;
    }

    @Override
    public void deleteAll() {
        IcsNaviTopicRelationDaoHandler.deleteAll(ICS_TOPICRELATION_MAPPER);
    }

    @Override
    public List<IcsTopicRelationDo> getRelationsByTopicId(String docId, String topicId) {
        return IcsNaviTopicRelationDaoHandler.getRelationsByTopicId(ICS_TOPICRELATION_MAPPER, docId, topicId);
    }

    private static class IcsNaviTopicRelationHandlerHolder {
        private static final IcsNaviTopicRelationServiceHandler INSTANCE = new IcsNaviTopicRelationServiceHandler();

        private IcsNaviTopicRelationHandlerHolder() {
        }
    }
}

