/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.service.impl;

import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageAdapter;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicDaoHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.NaviComponentsDto;
import com.huawei.support.icscbb.hwics.common.navi.dto.QueryMetaAndFilterDto;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviTopicMapper;
import com.huawei.support.icscbb.hwics.common.navi.parse.IcsNaviXmlDaoHandler;
import com.huawei.support.icscbb.hwics.common.navi.service.IcsNaviTopicService;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class IcsNaviTopicServiceHandler
implements IcsNaviTopicService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsNaviTopicServiceHandler.class);
    private static final IcsNaviTopicMapper ICS_TOPIC_MAPPER = (IcsNaviTopicMapper)DbMapperUtils.getMapper(IcsNaviTopicMapper.class);

    private IcsNaviTopicServiceHandler() {
    }

    public static IcsNaviTopicServiceHandler getInstance() {
        return IcsNaviTopicServiceHandlerHolder.INSTANCE;
    }

    @Override
    public int init(List<IcsTopicDo> topicDtos) {
        if (CollectionUtils.isEmpty(topicDtos)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "topicList is null when init naviTopic.");
            return 30100001;
        }
        IcsNaviTopicDaoHandler.addNaviTopics(ICS_TOPIC_MAPPER, topicDtos);
        return 30100000;
    }

    @Override
    public int deleteByDocId(String docId) {
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "docId is null when delete naviTopic.");
            return 30100021;
        }
        IcsNaviTopicDaoHandler.deleteNaviTopics(ICS_TOPIC_MAPPER, docId);
        IcsNaviXmlDaoHandler.remove(IcsLiteStorageAdapter.INSTANCE, docId);
        return 30100020;
    }

    @Override
    public void deleteAll() {
        IcsNaviTopicDaoHandler.deleteAll(ICS_TOPIC_MAPPER);
    }

    @Override
    public IcsTopicDo getTopic(String docId, String topicId) {
        return IcsNaviTopicDaoHandler.getNaviTopic(ICS_TOPIC_MAPPER, docId, topicId);
    }

    @Override
    public IcsTopicDo getOneTopicInNavi(String docId, String pidId, String topicId, String topicUrl) {
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "docId is null when getTopicByParameter.");
            return null;
        }
        return IcsNaviTopicDaoHandler.getOneTopicInNavi(ICS_TOPIC_MAPPER, docId, pidId, topicId, topicUrl);
    }

    @Override
    public NaviComponentsDto getNaviComponents(String docId, String pidId, boolean isReference) {
        List<IcsTopicDo> topics = IcsNaviTopicDaoHandler.getTopicsByDocId(ICS_TOPIC_MAPPER, docId, pidId, null);
        List<IcsTopicDo> naviTopics = topics.stream().filter(topic -> StringUtils.isNotBlank((CharSequence)topic.getTopicUrl())).collect(Collectors.toList());
        List<IcsTopicDo> reTopics = topics.stream().filter(topic -> StringUtils.isBlank((CharSequence)topic.getTopicUrl())).collect(Collectors.toList());
        ArrayList<IcsTopicDo> topicPids = isReference ? new ArrayList() : IcsNaviTopicDaoHandler.getTopicPidsByDocId(ICS_TOPIC_MAPPER, docId, pidId);
        NaviComponentsDto naviComponents = new NaviComponentsDto();
        naviComponents.setTopicPids(topicPids);
        naviComponents.setReTopics(reTopics);
        naviComponents.setNaviTopics(naviTopics);
        return naviComponents;
    }

    @Override
    public String getAll(String maindDocId, String docId, String pidId, List<QueryMetaAndFilterDto> queryMetaAndFilterDtos) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, pidId})) {
            return "";
        }
        return IcsNaviXmlDaoHandler.getAll(IcsLiteStorageAdapter.INSTANCE, maindDocId, docId, pidId, queryMetaAndFilterDtos);
    }

    @Override
    public String getFirstFloor(String maindDocId, String docId, String pidId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, pidId})) {
            return "";
        }
        return IcsNaviXmlDaoHandler.getFirstFloor(IcsLiteStorageAdapter.INSTANCE, maindDocId, docId, pidId);
    }

    @Override
    public String getChilds(String maindDocId, String docId, String pidId, String position) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, pidId, position})) {
            return "";
        }
        return IcsNaviXmlDaoHandler.getChilds(IcsLiteStorageAdapter.INSTANCE, maindDocId, docId, pidId, position);
    }

    @Override
    public String getByTopicId(String maindDocId, String docId, String pidId, String topicId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, pidId, topicId})) {
            return "";
        }
        return IcsNaviXmlDaoHandler.getByTopicId(IcsLiteStorageAdapter.INSTANCE, maindDocId, docId, pidId, topicId);
    }

    @Override
    public String getByTopicUrl(String maindDocId, String docId, String pidId, String topicUrl) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, pidId, topicUrl})) {
            return "";
        }
        return IcsNaviXmlDaoHandler.getByTopicUrl(IcsLiteStorageAdapter.INSTANCE, maindDocId, docId, pidId, topicUrl);
    }

    @Override
    public List<IcsTopicDo> getTopicPids(String docId, String pidId) {
        return IcsNaviTopicDaoHandler.getTopicPidsByDocId(ICS_TOPIC_MAPPER, docId, pidId);
    }

    @Override
    public List<IcsTopicDo> getNaviByPosition(String pidXmlPath, String naviPositions) {
        return IcsNaviTopicDaoHandler.getNaviByPosition(pidXmlPath, naviPositions);
    }

    @Override
    public List<IcsTopicDo> getNaviListByPidXmlPath(String pidXmlPath) {
        return IcsNaviTopicDaoHandler.getNaviListByPidXmlPath(pidXmlPath);
    }

    @Override
    public int getCountByPosition(String pidXmlPath, String naviPositions) {
        return IcsNaviTopicDaoHandler.getCountByPosition(pidXmlPath, naviPositions);
    }

    @Override
    public int getNaviCountByPidXmlPath(String pidXmlPath) {
        return IcsNaviTopicDaoHandler.getNaviListByPidXmlPath(pidXmlPath).size();
    }

    private static class IcsNaviTopicServiceHandlerHolder {
        private static final IcsNaviTopicServiceHandler INSTANCE = new IcsNaviTopicServiceHandler();

        private IcsNaviTopicServiceHandlerHolder() {
        }
    }
}

