/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.service.impl;

import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicDao;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicDaoHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.NaviComponentsDto;
import com.huawei.support.icscbb.hwics.common.navi.dto.QueryMetaAndFilterDto;
import com.huawei.support.icscbb.hwics.common.navi.parse.IcsNaviXmlDao;
import com.huawei.support.icscbb.hwics.common.navi.service.IcsNaviTopicService;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviTopicServiceHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IcsNaviTopicServiceImpl
implements IcsNaviTopicService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsNaviTopicServiceImpl.class);
    @Autowired
    private IcsNaviTopicDao icsNaviTopicDao;
    @Autowired
    private IcsNaviXmlDao icsNaviXmlDao;

    @Override
    public int init(List<IcsTopicDo> icsTopicDos) {
        if (CollectionUtils.isEmpty(icsTopicDos)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "topicList is null when init naviTopic.");
            return 30100001;
        }
        this.icsNaviTopicDao.addNaviTopics(icsTopicDos);
        return 30100000;
    }

    @Override
    public int deleteByDocId(String docId) {
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "docId is null when delete naviTopic.");
            return 30100021;
        }
        int topicsCount = this.icsNaviTopicDao.getTopicsCount(docId);
        int times = topicsCount / 1000;
        for (int i = 0; i <= times; ++i) {
            this.icsNaviTopicDao.deleteNaviTopics(docId);
        }
        this.icsNaviXmlDao.remove(docId);
        return 30100020;
    }

    @Override
    public void deleteAll() {
    }

    @Override
    public IcsTopicDo getTopic(String docId, String topicId) {
        return this.icsNaviTopicDao.getNaviTopic(docId, topicId);
    }

    @Override
    public IcsTopicDo getOneTopicInNavi(String docId, String pidId, String topicId, String topicUrl) {
        if (StringUtils.isBlank((CharSequence)docId)) {
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "docId is null when getTopicByParameter.");
            return null;
        }
        return this.icsNaviTopicDao.getOneTopicInNavi(docId, pidId, topicId, topicUrl);
    }

    @Override
    public NaviComponentsDto getNaviComponents(String docId, String pidId, boolean isReference) {
        List<IcsTopicDo> topics = this.icsNaviTopicDao.getTopicsByDocId(docId, pidId, null);
        List<IcsTopicDo> naviTopics = topics.stream().filter(topic -> StringUtils.isNotBlank((CharSequence)topic.getTopicUrl())).collect(Collectors.toList());
        List<IcsTopicDo> reTopics = topics.stream().filter(topic -> StringUtils.isBlank((CharSequence)topic.getTopicUrl())).collect(Collectors.toList());
        ArrayList<IcsTopicDo> topicPids = isReference ? new ArrayList<IcsTopicDo>() : this.icsNaviTopicDao.getTopicPidsByDocId(docId, pidId);
        NaviComponentsDto naviComponents = new NaviComponentsDto();
        naviComponents.setNaviTopics(naviTopics);
        naviComponents.setReTopics(reTopics);
        naviComponents.setTopicPids(topicPids);
        return naviComponents;
    }

    @Override
    public String getAll(String maindDocId, String docId, String pidId, List<QueryMetaAndFilterDto> queryMetaAndFilterDtos) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, pidId})) {
            return "";
        }
        return this.icsNaviXmlDao.getAll(maindDocId, docId, pidId, queryMetaAndFilterDtos);
    }

    @Override
    public String getFirstFloor(String maindDocId, String docId, String pidId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, pidId})) {
            return "";
        }
        return this.icsNaviXmlDao.getFirstFloor(maindDocId, docId, pidId);
    }

    @Override
    public String getChilds(String maindDocId, String docId, String pidId, String position) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, pidId, position})) {
            return "";
        }
        return this.icsNaviXmlDao.getChilds(maindDocId, docId, pidId, position);
    }

    @Override
    public String getByTopicId(String maindDocId, String docId, String pidId, String topicId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, pidId, topicId})) {
            return "";
        }
        return this.icsNaviXmlDao.getByTopicId(maindDocId, docId, pidId, topicId);
    }

    @Override
    public String getByTopicUrl(String maindDocId, String docId, String pidId, String topicUrl) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{docId, pidId, topicUrl})) {
            return "";
        }
        return this.icsNaviXmlDao.getByTopicUrl(maindDocId, docId, pidId, topicUrl);
    }

    @Override
    public List<IcsTopicDo> getTopicPids(String docId, String pidId) {
        return this.icsNaviTopicDao.getTopicPidsByDocId(docId, pidId);
    }

    @Override
    public List<IcsTopicDo> getNaviByPosition(String pidXmlPath, String naviPositions) {
        return IcsNaviTopicServiceHandler.getInstance().getNaviByPosition(pidXmlPath, naviPositions);
    }

    @Override
    public int getCountByPosition(String pidXmlPath, String naviPositions) {
        return IcsNaviTopicServiceHandler.getInstance().getCountByPosition(pidXmlPath, naviPositions);
    }

    @Override
    public List<IcsTopicDo> getNaviListByPidXmlPath(String pidXmlPath) {
        return IcsNaviTopicDaoHandler.getNaviListByPidXmlPath(pidXmlPath);
    }

    @Override
    public int getNaviCountByPidXmlPath(String pidXmlPath) {
        return IcsNaviTopicDaoHandler.getNaviListByPidXmlPath(pidXmlPath).size();
    }
}

