/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.service.impl;

import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageAdapter;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviStatusDaoHandler;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicDaoHandler;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicMetaDaoHandler;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicRelationDaoHandler;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsNaviStatusDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicBaseDo;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviStatusMapper;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviTopicMapper;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviTopicMetaMapper;
import com.huawei.support.icscbb.hwics.common.navi.mapper.IcsNaviTopicRelationMapper;
import com.huawei.support.icscbb.hwics.common.navi.parse.SaxParserPid;
import com.huawei.support.icscbb.hwics.common.navi.service.NaviInitService;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviServiceCommonMethod;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviStatusServiceHandler;
import com.huawei.support.icscbb.hwics.common.navi.util.IcsNaviUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.db.DbMapperUtils;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NaviInitServiceHandler
implements NaviInitService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(NaviInitServiceHandler.class);
    private static final IcsNaviTopicMapper ICS_TOPIC_MAPPER = (IcsNaviTopicMapper)DbMapperUtils.getMapper(IcsNaviTopicMapper.class);
    private static final IcsNaviTopicMetaMapper ICS_TOPICMETA_MAPPER = (IcsNaviTopicMetaMapper)DbMapperUtils.getMapper(IcsNaviTopicMetaMapper.class);
    private static final IcsNaviTopicRelationMapper ICS_TOPICRELATION_MAPPER = (IcsNaviTopicRelationMapper)DbMapperUtils.getMapper(IcsNaviTopicRelationMapper.class);
    private static final IcsNaviStatusMapper ICS_STATUS_MAPPER = (IcsNaviStatusMapper)DbMapperUtils.getMapper(IcsNaviStatusMapper.class);

    private NaviInitServiceHandler() {
    }

    public static NaviInitServiceHandler getInstance() {
        return NaviInitHandlerHolder.INSTANCE;
    }

    @Override
    public void createNaviTb() {
        IcsNaviTopicDaoHandler.createNaviTopicTb(ICS_TOPIC_MAPPER);
        IcsNaviTopicMetaDaoHandler.creatTopicMetaTb(ICS_TOPICMETA_MAPPER);
        IcsNaviTopicRelationDaoHandler.creatTopicRelationTb(ICS_TOPICRELATION_MAPPER);
        IcsNaviStatusDaoHandler.createNaviTopicTb(ICS_STATUS_MAPPER);
    }

    @Override
    public boolean initNaviToDb(String path, IcsTopicBaseDo profileInfo, List<String> pids) {
        boolean isSuccess = true;
        this.deleteNaviFromTb(profileInfo);
        if (!IcsNaviServiceCommonMethod.parsePid(path, profileInfo, pids, null)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, String.format(Locale.ENGLISH, "init navi--parsePid failed. CODE:%d", 30100003));
            isSuccess = false;
        }
        if (!IcsNaviServiceCommonMethod.parseMeta(path, profileInfo, null, null)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, String.format(Locale.ENGLISH, "init navi--parseMeta failed. CODE:%d", 30100004));
            isSuccess = false;
        }
        return isSuccess;
    }

    private void deleteNaviFromTb(IcsTopicBaseDo profileInfo) {
        String docId = profileInfo.getDocId();
        if (StringUtils.isNotBlank((CharSequence)docId)) {
            IcsNaviTopicDaoHandler.deleteNaviTopics(ICS_TOPIC_MAPPER, profileInfo.getDocId());
            IcsNaviTopicMetaDaoHandler.deleteNaviTopicMetas(ICS_TOPICMETA_MAPPER, profileInfo.getDocId());
            IcsNaviTopicRelationDaoHandler.deleteNaviTopicRelations(ICS_TOPICRELATION_MAPPER, profileInfo.getDocId());
        }
    }

    @Override
    public boolean initNavi(IcsTopicBaseDo profileInfo, List<String> pids, Map<String, String> rePaths) {
        AtomicBoolean isSuccess = new AtomicBoolean(false);
        if (profileInfo == null) {
            return isSuccess.get();
        }
        String docId = profileInfo.getDocId();
        if (CollectionUtils.isEmpty(pids) || MapUtils.isEmpty(rePaths)) {
            return isSuccess.get();
        }
        if (MapUtils.isEmpty(rePaths)) {
            isSuccess.set(this.initPids(null, docId, pids, rePaths));
        } else {
            rePaths.forEach((key, Value) -> {
                if (StringUtils.equals((CharSequence)key, (CharSequence)docId)) {
                    isSuccess.set(this.initPids(null, docId, pids, rePaths));
                } else {
                    isSuccess.set(this.initPids(docId, (String)key, this.getPids((String)key), IcsNaviServiceCommonMethod.modifyMapOrder(key, rePaths)));
                }
            });
        }
        return isSuccess.get();
    }

    private List<String> getPids(String docId) {
        return IcsNaviTopicDaoHandler.getPidsByDocId(ICS_TOPIC_MAPPER, docId);
    }

    private boolean initPids(String maindDocId, String docId, List<String> pids, Map<String, String> rePaths) {
        boolean isSuccess = false;
        String statusDocId = docId;
        if (StringUtils.isNotBlank((CharSequence)maindDocId) && !StringUtils.equals((CharSequence)maindDocId, (CharSequence)docId)) {
            statusDocId = String.format(Locale.ENGLISH, "%s_%s", maindDocId, docId);
        }
        for (String pid : pids) {
            IcsNaviStatusDo status = IcsNaviStatusServiceHandler.getInstance().getPidByDocId(statusDocId, pid);
            boolean pidSuccess = this.parsePid(maindDocId, docId, pid, rePaths, status = this.initPidStatus(statusDocId, pid, status));
            if (pidSuccess) {
                isSuccess = true;
                this.updateStatus(status, "100");
            } else {
                isSuccess = false;
                this.updateStatus(status, "103");
            }
            CodeCCUtils.INSTANCE.debugLog(LOGGER, "Create Pid XML. docId: {0}, pidId: {1}, status: {2}", new Object[]{docId, pid, pidSuccess});
        }
        return isSuccess;
    }

    private IcsNaviStatusDo initPidStatus(String docId, String pid, IcsNaviStatusDo status) {
        if (status == null) {
            status = new IcsNaviStatusDo();
            status.setDocId(docId);
            status.setPidId(pid);
            status.setStatus("101");
            IcsNaviStatusServiceHandler.getInstance().add(status);
        } else {
            status.setStatus("201");
            IcsNaviStatusServiceHandler.getInstance().updateStatus(status);
        }
        return status;
    }

    private void updateStatus(IcsNaviStatusDo statusDo, String newStatus) {
        IcsNaviStatusServiceHandler.getInstance().updateStatus(IcsNaviServiceCommonMethod.getUpdateStatusDo(statusDo, newStatus));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parsePid(String maindDocId, String docId, String pidId, Map<String, String> rePaths, IcsNaviStatusDo status) {
        boolean isSuccess = false;
        String filePath = String.format(Locale.ENGLISH, "resources/infocenter_service/map/%s.xml", pidId);
        CodeCCUtils.INSTANCE.debugLog(LOGGER, "pid filePath" + filePath);
        try (InputStream is = ZipFilePool.getInputStream((String)rePaths.get(docId), (String)filePath);){
            if (is == null) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, String.format(Locale.ENGLISH, "%s.xml is not found.", pidId));
                boolean bl = isSuccess;
                return bl;
            }
            this.updateStatus(status, "102");
            SaxParserPid saxParser = new SaxParserPid(IcsNaviUtil.getPidXmlPath(maindDocId, docId, pidId, IcsLiteStorageAdapter.INSTANCE.getIcsNavPath()), 0).setIcsNaviTopicMetaDao(null).setRootDocId(docId).setPidId(pidId).setPaths(rePaths);
            SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)saxParser);
            isSuccess = true;
            return isSuccess;
        }
        catch (IOException | SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, String.format(Locale.ENGLISH, "Error parserXml %s.xml.", pidId), (Throwable)e);
            return false;
        }
    }

    private static class NaviInitHandlerHolder {
        private static final NaviInitServiceHandler INSTANCE = new NaviInitServiceHandler();

        private NaviInitHandlerHolder() {
        }
    }
}

