/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.service.impl;

import com.huawei.support.icscbb.adapter.storage.adapter.IcsLiteStorageAdapter;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicDao;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicMetaDao;
import com.huawei.support.icscbb.hwics.common.navi.dao.IcsNaviTopicRelationDao;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsNaviStatusDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicBaseDo;
import com.huawei.support.icscbb.hwics.common.navi.parse.SaxParserPid;
import com.huawei.support.icscbb.hwics.common.navi.service.IcsNaviStatusService;
import com.huawei.support.icscbb.hwics.common.navi.service.NaviInitService;
import com.huawei.support.icscbb.hwics.common.navi.service.impl.IcsNaviServiceCommonMethod;
import com.huawei.support.icscbb.hwics.common.navi.util.IcsNaviUtil;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Service
public class NaviInitServiceImpl
implements NaviInitService {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(NaviInitServiceImpl.class);
    @Autowired
    private IcsNaviTopicDao icsNaviTopicDao;
    @Autowired
    private IcsNaviTopicMetaDao icsNaviTopicMetaDao;
    @Autowired
    private IcsNaviTopicRelationDao icsNaviTopicRelationDao;
    @Autowired
    private IcsLiteStorageAdapter icsLiteStorageAdapter;
    @Autowired
    private IcsNaviStatusService icsNaviStatusService;

    @Override
    public void createNaviTb() {
        this.icsNaviTopicDao.createNaviTopicTb();
        this.icsNaviTopicMetaDao.creatTopicMetaTb();
        this.icsNaviTopicRelationDao.creatTopicRelationTb();
        this.icsNaviStatusService.createTb();
    }

    @Override
    public boolean initNaviToDb(String path, IcsTopicBaseDo profileInfo, List<String> pids) {
        boolean isSuccess = true;
        if (!IcsNaviServiceCommonMethod.parsePid(path, profileInfo, pids, this.icsNaviTopicDao)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, String.format(Locale.ENGLISH, "init navi--parsePid failed. CODE:%d", 30100003));
            isSuccess = false;
        }
        if (!IcsNaviServiceCommonMethod.parseMeta(path, profileInfo, this.icsNaviTopicMetaDao, this.icsNaviTopicRelationDao)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, String.format(Locale.ENGLISH, "init navi--parseMeta failed. CODE:%d", 30100004));
            isSuccess = false;
        }
        return isSuccess;
    }

    @Override
    public boolean initNavi(IcsTopicBaseDo profileInfo, List<String> pids, Map<String, String> rePaths) {
        AtomicBoolean isSuccess = new AtomicBoolean(false);
        if (profileInfo == null) {
            return isSuccess.get();
        }
        String docId = profileInfo.getDocId();
        if (CollectionUtils.isEmpty(pids) || MapUtils.isEmpty(rePaths)) {
            return isSuccess.get();
        }
        if (MapUtils.isEmpty(rePaths)) {
            isSuccess.set(this.initPids(null, docId, pids, rePaths));
        } else {
            rePaths.forEach((key, value) -> {
                if (StringUtils.equals((CharSequence)key, (CharSequence)docId)) {
                    isSuccess.set(this.initPids(null, docId, pids, rePaths));
                } else {
                    isSuccess.set(this.initPids(docId, (String)key, this.getPids((String)key), IcsNaviServiceCommonMethod.modifyMapOrder(key, rePaths)));
                }
            });
        }
        return isSuccess.get();
    }

    private List<String> getPids(String docId) {
        return this.icsNaviTopicDao.getPidsByDocId(docId);
    }

    private boolean initPids(String maindDocId, String docId, List<String> pids, Map<String, String> rePaths) {
        boolean isSuccess = false;
        String statusDocId = docId;
        if (StringUtils.isNotBlank((CharSequence)maindDocId) && !StringUtils.equals((CharSequence)maindDocId, (CharSequence)docId)) {
            statusDocId = String.format(Locale.ENGLISH, "%s_%s", maindDocId, docId);
        }
        for (String pid : pids) {
            IcsNaviStatusDo status = this.icsNaviStatusService.getPidByDocId(statusDocId, pid);
            boolean pidSuccess = this.parsePid(maindDocId, docId, pid, rePaths, status = this.initPidStatus(statusDocId, pid, status));
            if (pidSuccess) {
                isSuccess = true;
                this.updateStatus(status, "100");
            } else {
                isSuccess = false;
                this.updateStatus(status, "103");
            }
            CodeCCUtils.INSTANCE.debugLog(LOGGER, "Create Pid XML. docId: {0}, pidId: {1}, status: {2}", new Object[]{docId, pid, pidSuccess});
        }
        return isSuccess;
    }

    private IcsNaviStatusDo initPidStatus(String docId, String pid, IcsNaviStatusDo status) {
        if (status == null) {
            status = new IcsNaviStatusDo();
            status.setDocId(docId);
            status.setPidId(pid);
            status.setStatus("101");
            this.icsNaviStatusService.add(status);
        } else {
            status.setStatus("201");
            this.icsNaviStatusService.updateStatus(status);
        }
        return status;
    }

    private void updateStatus(IcsNaviStatusDo statusDo, String newStatus) {
        this.icsNaviStatusService.updateStatus(IcsNaviServiceCommonMethod.getUpdateStatusDo(statusDo, newStatus));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parsePid(String maindDocId, String docId, String pidId, Map<String, String> rePaths, IcsNaviStatusDo status) {
        boolean isSuccess = false;
        String filePath = String.format(Locale.ENGLISH, "resources/infocenter_service/map/%s.xml", pidId);
        CodeCCUtils.INSTANCE.debugLog(LOGGER, "pid filePath" + filePath);
        try (InputStream is = ZipFilePool.getInputStream((String)rePaths.get(docId), (String)filePath);){
            if (is == null) {
                CodeCCUtils.INSTANCE.infoLog(LOGGER, String.format(Locale.ENGLISH, "%s.xml is not found.", pidId));
                boolean bl = isSuccess;
                return bl;
            }
            this.updateStatus(status, "102");
            SaxParserPid saxParser = new SaxParserPid(IcsNaviUtil.getPidXmlPath(maindDocId, docId, pidId, this.icsLiteStorageAdapter.getIcsNavPath()), 0).setIcsNaviTopicMetaDao(this.icsNaviTopicMetaDao).setRootDocId(docId).setPidId(pidId).setPaths(rePaths);
            SAXParserUtils.parseXml((InputStream)is, (DefaultHandler)saxParser);
            isSuccess = true;
            return isSuccess;
        }
        catch (IOException | SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, String.format(Locale.ENGLISH, "Error parserXml %s.xml.", pidId), (Throwable)e);
            return false;
        }
    }
}

