/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.hwics.common.navi.util;

import com.huawei.support.icscbb.hwics.common.navi.constant.NaviCommonConstants;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicDo;
import com.huawei.support.icscbb.hwics.common.navi.dto.IcsTopicPageDto;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;

public class IcsNaviUtil {
    public static String getStringDate() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(currentTime);
    }

    public static String getAttributeValue(Attributes attributes, String attrName) {
        String value = attributes.getValue(attrName);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    public static Map<String, String> getlimitMap(final int maximumSize) {
        return new LinkedHashMap<String, String>(){
            private static final long serialVersionUID = 7316187426128873738L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                return this.size() > maximumSize;
            }
        };
    }

    public static String getDocDirPath(String docId, String storagePath) {
        return String.format(Locale.ENGLISH, NaviCommonConstants.NAVI_PATH_PRE, storagePath, docId);
    }

    public static String getPidXmlPath(String maindDocId, String docId, String pidId, String storagePath) {
        if (StringUtils.isBlank((CharSequence)maindDocId) || StringUtils.equals((CharSequence)maindDocId, (CharSequence)docId)) {
            return String.format(Locale.ENGLISH, NaviCommonConstants.NEW_NAVIXML_PATH, storagePath, docId, pidId);
        }
        return String.format(Locale.ENGLISH, NaviCommonConstants.NEW_NAVIXML_RELATION_PATH, storagePath, maindDocId, docId, pidId);
    }

    public static IcsTopicPageDto getPage(Integer pageNo, Integer pageSize, int topicsCount) {
        IcsTopicPageDto pageDto = null;
        if (pageNo < 1 || pageSize <= 0 || topicsCount <= 0) {
            return pageDto;
        }
        pageDto = new IcsTopicPageDto();
        pageDto.setPageNo(pageNo);
        pageDto.setPageSize(pageSize);
        pageDto.setTotalCount(topicsCount);
        int totalPageCount = 0;
        totalPageCount = topicsCount % pageSize == 0 ? topicsCount / pageSize : topicsCount / pageSize + 1;
        if (pageNo > totalPageCount) {
            return null;
        }
        pageDto.setTotalPageCount(totalPageCount);
        int index = (pageNo - 1) * pageSize;
        pageDto.setIndex(index);
        return pageDto;
    }

    public static IcsTopicDo getIcsTopicDo(Attributes attributes) {
        IcsTopicDo icsTopicDo = new IcsTopicDo();
        icsTopicDo.setDocId(attributes.getValue("docId"));
        icsTopicDo.setTopicId(attributes.getValue("id"));
        icsTopicDo.setName(attributes.getValue("txt"));
        icsTopicDo.setTopicUrl(attributes.getValue("url"));
        icsTopicDo.setPosition(attributes.getValue("position"));
        return icsTopicDo;
    }
}

