/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.ics.common.adapter.encryption.service.factory;

import com.huawei.support.ics.common.adapter.encryption.service.DataSecurity;
import com.huawei.support.ics.common.adapter.encryption.service.impl.DpapiDataSecurityHandler;
import com.huawei.support.ics.common.adapter.encryption.service.impl.KmcDataSecurityHandler;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;

public class DataSecurityHandlerFactory {
    public static final String ENCRYPT_MODE_KMC = "KMC";
    public static final String ENCRYPT_MODE_DPAPI = "DPAPI";
    private static ConcurrentHashMap<String, DataSecurity> handlerMap = new ConcurrentHashMap();

    private DataSecurityHandlerFactory() {
    }

    private static void init() {
        Object handler = KmcDataSecurityHandler.getInstance();
        if (ObjectUtils.isNotEmpty((Object)handler)) {
            handlerMap.put(ENCRYPT_MODE_KMC, (DataSecurity)handler);
        }
        if (ObjectUtils.isNotEmpty((Object)(handler = DpapiDataSecurityHandler.getInstance()))) {
            handlerMap.put(ENCRYPT_MODE_DPAPI, (DataSecurity)handler);
        }
    }

    public static DataSecurity getInstance(String type) {
        return handlerMap.get(type);
    }

    static {
        DataSecurityHandlerFactory.init();
    }
}

