/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.ics.common.adapter.encryption.service.impl;

import com.huawei.support.ics.common.adapter.encryption.service.dpapi.Dpapi4j;
import com.huawei.support.ics.common.adapter.encryption.service.dpapi.DpapiCryptMode;
import com.huawei.support.ics.common.adapter.encryption.service.dpapi.DpapiException;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.common.service.SecurityLogUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.properties.PropertiesUtils;
import com.huawei.wsf.core.HWRandomizer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.owasp.esapi.EncoderConstants;

public class DpapiMacGeneratorHelper {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(DpapiMacGeneratorHelper.class);
    private static final SecurityLogUtils SECURITY_LOGGER = SecurityLogUtils.INSTANCE;
    private static final int DEFAULT_KEY_LENGTH = 32;
    private static final String WORK_KEY = "mac.generator.key";
    private static String securityConfigPath = "securityConfig.properties";
    private static Dpapi4j dpapi;

    private DpapiMacGeneratorHelper() {
        DpapiMacGeneratorHelper.init();
    }

    DpapiMacGeneratorHelper(String configFilePath) {
        securityConfigPath = configFilePath;
    }

    private static void init() {
        try {
            dpapi = Dpapi4j.newInstance(DpapiCryptMode.CRYPTPROTECT_UI_FORBIDDEN);
        }
        catch (DpapiException e) {
            SECURITY_LOGGER.securityLog("CommonAdapterService-encryption-service", "MacGeneratorHelper.init Exception", (Throwable)e);
        }
        catch (UnsatisfiedLinkError error) {
            SECURITY_LOGGER.securityLog("CommonAdapterService-encryption-service", "MacGeneratorHelper.init  error", (Throwable)error);
        }
    }

    public static void setConfigFilePath(String pathPah) {
        securityConfigPath = pathPah;
    }

    public static final DpapiMacGeneratorHelper getInstance() {
        return MacGeneratorHelperHolder.INSTANCE;
    }

    public String getMacGenerator() throws DpapiException {
        Properties configProps;
        if (!Dpapi4j.isOsSupported(dpapi)) {
            return "";
        }
        File configFile = FileUtils.getFile((String[])new String[]{securityConfigPath});
        if (!configFile.exists()) {
            this.createConfigFile(configFile);
        }
        if ((configProps = PropertiesUtils.getPropertiesByFile((File)configFile)) == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "SecurityConfig Properties load failed.");
            return "";
        }
        String encryptWorkKeyStr = configProps.getProperty(WORK_KEY);
        if (StringUtils.isBlank((CharSequence)encryptWorkKeyStr)) {
            String plainWorkKey = HWRandomizer.getRandomString((int)32, (char[])EncoderConstants.CHAR_ALPHANUMERICS);
            byte[] encryptWorkKeyBytes = dpapi.protectData(plainWorkKey.getBytes(StandardCharsets.UTF_8));
            encryptWorkKeyStr = Base64.encodeBase64String((byte[])encryptWorkKeyBytes);
            configProps.put(WORK_KEY, encryptWorkKeyStr);
            PropertiesUtils.storeProperties((Properties)configProps, (String)securityConfigPath);
        }
        return new String(dpapi.unprotectData(Base64.decodeBase64((String)encryptWorkKeyStr)), StandardCharsets.UTF_8);
    }

    private boolean createConfigFile(File configFile) {
        try {
            if (!configFile.createNewFile()) {
                SECURITY_LOGGER.errorLog(LOGGER, "Create securityConfig.properties failed.");
                return false;
            }
        }
        catch (IOException e) {
            SECURITY_LOGGER.errorLog(LOGGER, "The securityConfig.properties file does not exist and create failed.IOException.");
            return false;
        }
        return true;
    }

    public String getRefreshMacGenerator() throws DpapiException {
        Properties configProps;
        if (!Dpapi4j.isOsSupported(dpapi)) {
            return "";
        }
        File configFile = FileUtils.getFile((String[])new String[]{securityConfigPath});
        if (!configFile.exists()) {
            this.createConfigFile(configFile);
        }
        if ((configProps = PropertiesUtils.getPropertiesByFile((File)configFile)) == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "SecurityConfig Properties load failed.");
            return "";
        }
        String newPlainWorkKeyStr = HWRandomizer.getRandomString((int)32, (char[])EncoderConstants.CHAR_ALPHANUMERICS);
        byte[] encryptWorkKeyBytes = dpapi.protectData(newPlainWorkKeyStr.getBytes(StandardCharsets.UTF_8));
        configProps.put(WORK_KEY, Base64.encodeBase64String((byte[])encryptWorkKeyBytes));
        PropertiesUtils.storeProperties((Properties)configProps, (String)securityConfigPath);
        return newPlainWorkKeyStr;
    }

    private static class MacGeneratorHelperHolder {
        private static final DpapiMacGeneratorHelper INSTANCE = new DpapiMacGeneratorHelper();

        private MacGeneratorHelperHolder() {
        }
    }
}

