/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.ics.common.adapter.encryption.service.impl;

import com.google.common.eventbus.AsyncEventBus;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.Errno;
import com.huawei.kmc.crypt.CryptoAPI;
import com.huawei.support.ics.common.adapter.encryption.service.DataSecurity;
import com.huawei.support.ics.common.adapter.encryption.service.kmc.common.KmcKeyManagerHandler;
import com.huawei.support.ics.common.adapter.encryption.service.kmc.exception.KmcPropertiesException;
import com.huawei.support.icscbb.log.common.service.SecurityLogUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;

public class KmcDataSecurityHandler
implements DataSecurity {
    private static final int FILL_CONST = 3;
    private static final AtomicBoolean IS_THREAD_ENABLE = new AtomicBoolean(true);
    private static final String KE_RET_SUCCESS_CODE = String.valueOf(Errno.KE_RET_SUCCESS.getCode());
    private static final String KE_ERR_OPEN_FILE_CODE = String.valueOf(Errno.KE_ERR_OPEN_FILE.getCode());
    private static final List<String> KE_APP_EXCEPTION_MESSAGE_SET = Collections.unmodifiableList(new ArrayList<String>(){
        private static final long serialVersionUID = 2992990614343938100L;
        {
            this.add("error code " + KE_ERR_OPEN_FILE_CODE);
            this.add("result=" + KE_ERR_OPEN_FILE_CODE);
        }
    });
    private static KmcKeyManagerHandler kmcKeyManager;
    private CryptoAPI encryptApi = null;

    private KmcDataSecurityHandler() {
        this.init();
    }

    public static final KmcDataSecurityHandler getInstanceByinit(AsyncEventBus asyncEventBus, Properties properties) throws KmcPropertiesException {
        if (IS_THREAD_ENABLE.compareAndSet(true, false)) {
            kmcKeyManager = new KmcKeyManagerHandler(asyncEventBus, properties);
            kmcKeyManager.init();
        }
        return DataSecurityHandlerHolder.INSTANCE;
    }

    public static final KmcDataSecurityHandler getInstance() {
        KmcDataSecurityHandler resultNull = null;
        if (kmcKeyManager == null) {
            return resultNull;
        }
        return DataSecurityHandlerHolder.INSTANCE;
    }

    private void init() {
        Object instance = kmcKeyManager.getInstance();
        if (!(instance instanceof CryptoAPI)) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "CryptoAPI class type error");
            return;
        }
        if (this.encryptApi == null) {
            this.encryptApi = (CryptoAPI)instance;
        }
    }

    public boolean isNormalEnv() {
        return this.encryptApi != null;
    }

    public byte[] encrypt(int domainId, String plainText) {
        byte[] plainText1 = plainText.getBytes(StandardCharsets.UTF_8);
        byte[] encrypt = new byte[]{};
        try {
            if (this.isNormalEnv()) {
                encrypt = this.encryptApi.encrypt(domainId, plainText1);
            }
        }
        catch (AppException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "domainId %s : DataSecurityImpl.encrypt AppException", domainId), (Throwable)e);
        }
        return encrypt;
    }

    public String decrpy(int domainId, byte[] encrypt) {
        byte[] decrypt = new byte[]{};
        try {
            if (this.isNormalEnv()) {
                decrypt = this.encryptApi.decrypt(domainId, encrypt);
            }
        }
        catch (AppException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "domainId %s : DataSecurityImpl.decrpy AppException", domainId), (Throwable)e);
            return "";
        }
        String result = new String(decrypt, StandardCharsets.UTF_8);
        for (int num = 0; num < 3; ++num) {
            Arrays.fill(decrypt, (byte)0);
        }
        return result;
    }

    public byte[] reEncrypt(int domainId, byte[] encrypt) {
        byte[] reEncrypt = new byte[]{};
        try {
            if (this.isNormalEnv()) {
                reEncrypt = this.encryptApi.reEncrypt(domainId, encrypt);
            }
        }
        catch (AppException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "domainId %s : DataSecurityImpl.reEncrypt AppException", domainId), (Throwable)e);
        }
        return reEncrypt;
    }

    public byte[] hmac(int domainId, byte[] plainText) {
        byte[] hmac = new byte[]{};
        try {
            if (this.isNormalEnv()) {
                hmac = this.encryptApi.hmac(domainId, plainText);
            }
        }
        catch (AppException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "domainId %s : DataSecurityImpl.hmac AppExceptio", domainId), (Throwable)e);
        }
        return hmac;
    }

    public boolean isHmacVerify(int domainId, byte[] plainText, byte[] hmacData) {
        boolean isHmacResult = false;
        try {
            if (this.isNormalEnv()) {
                isHmacResult = this.encryptApi.hmacVerify(domainId, plainText, hmacData);
            }
        }
        catch (AppException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "domainId %s : DataSecurityImpl.isHmacVerify AppException", domainId), (Throwable)e);
        }
        return isHmacResult;
    }

    public String getKeyStatusCode(int domainId) {
        try {
            if (this.isNormalEnv()) {
                String testDemoStr = "1";
                byte[] plainText = testDemoStr.getBytes(StandardCharsets.UTF_8);
                this.encryptApi.encrypt(domainId, plainText);
            }
        }
        catch (AppException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "domainId {0} :  encryptApi.encrypt AppException", new Object[]{e, domainId});
            for (String message : KE_APP_EXCEPTION_MESSAGE_SET) {
                if (!StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)message)) continue;
                return KE_ERR_OPEN_FILE_CODE;
            }
        }
        return KE_RET_SUCCESS_CODE;
    }

    private static class DataSecurityHandlerHolder {
        private static final KmcDataSecurityHandler INSTANCE = new KmcDataSecurityHandler();

        private DataSecurityHandlerHolder() {
        }
    }
}

