/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.ics.common.adapter.encryption.service.kmc.common;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.ILogger;
import com.huawei.kmc.common.INotifyCallback;
import com.huawei.kmc.common.KmcMkInfo;
import com.huawei.kmc.crypt.CryptoAPI;
import com.huawei.support.ics.common.adapter.encryption.service.kmc.common.KeyManager;
import com.huawei.support.ics.common.adapter.encryption.service.kmc.common.KmcLogger;
import com.huawei.support.ics.common.adapter.encryption.service.kmc.common.KmcNotifyCallback;
import com.huawei.support.ics.common.adapter.encryption.service.kmc.common.KmcPropertiesValidate;
import com.huawei.support.ics.common.adapter.encryption.service.kmc.exception.KmcPropertiesException;
import com.huawei.support.icscbb.log.common.service.SecurityLogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public class KmcKeyManagerHandler
implements KeyManager {
    private static final int CORE_POOL_SIZE = 4;
    private final Object lock = new Object();
    private AsyncEventBus eventBus;
    private Properties securityProperties;
    private CryptoAPI cryptoApiInstance;
    private volatile int domainCount;
    private ScheduledExecutorService scheduledExecutorService;

    public KmcKeyManagerHandler(AsyncEventBus asyncEventBus, Properties properties) throws KmcPropertiesException {
        Properties kmcSecurityPro;
        this.securityProperties = kmcSecurityPro = this.getSecurityProperties(properties);
        this.eventBus = asyncEventBus;
    }

    private void loadKmcLib(String kmcDllLibAbsoultPath) throws UnsatisfiedLinkError {
        System.load(kmcDllLibAbsoultPath + "ucrtbase.dll");
        System.load(kmcDllLibAbsoultPath + "libcrypto-1_1.dll");
        System.load(kmcDllLibAbsoultPath + "vcruntime140.dll");
        System.load(kmcDllLibAbsoultPath + "securec.dll");
        System.load(kmcDllLibAbsoultPath + "kmc.dll");
        System.load(kmcDllLibAbsoultPath + "sdp.dll");
        System.load(kmcDllLibAbsoultPath + "kmcext.dll");
        System.load(kmcDllLibAbsoultPath + "kmcjni.dll");
    }

    @Override
    public void init() {
        try {
            String kmcDllLibAbsoultPath = this.securityProperties.getProperty("kmcDllLibAbsolutePath");
            this.loadKmcLib(kmcDllLibAbsoultPath);
            this.scheduledExecutorService = new ScheduledThreadPoolExecutor(4, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("KMC-Scheduled-Task-%d").build());
            this.initInstance();
            this.setKmcFilePermission();
            this.activeDomainKey();
            this.updateMainKey();
            this.updateRootKey();
            this.refreshMaskTask();
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", this.getKeyManageInfo());
        }
        catch (AppException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "kmcKeyManager.initialize AppException", (Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "kmcKeyManager.initialize UnsatisfiedLinkError", (Throwable)e);
        }
    }

    private synchronized void initInstance() {
        if (CryptoAPI.getInitStage() == 2) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "CryptoAPI init already");
            return;
        }
        try {
            CryptoAPI.setJniLogger((ILogger)new KmcLogger());
            CryptoAPI.setLogLevel((ILogger.LogLevel)ILogger.LogLevel.INFO);
            String backupPath = this.securityProperties.getProperty("backupPath");
            CryptoAPI.setJniNotifyCallback((INotifyCallback)new KmcNotifyCallback(backupPath, this.eventBus, 0));
            this.cryptoApiInstance = CryptoAPI.getInstance();
            this.cryptoApiInstance.initialize(this.securityProperties);
            if (CryptoAPI.getInitStage() == 2) {
                SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "Init success");
            } else if (CryptoAPI.getInitStage() == 1) {
                SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "loading dll");
            } else {
                SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "init fail");
            }
        }
        catch (AppException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "cryptoApiInstance.initialize AppException", (Throwable)e);
        }
    }

    private synchronized void activeDomainKey() throws AppException {
        this.domainCount = this.getPropertyInteger("domain_count");
        for (int num = 0; num < this.domainCount; ++num) {
            int maxMkId = this.cryptoApiInstance.getMaxMkID(num);
            if (maxMkId != 0) continue;
            this.cryptoApiInstance.activeNewKey(num);
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "active %d domain key", num));
        }
        SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "activeDomainKey success");
    }

    private int getPropertyInteger(String key) {
        String stringProperty = this.securityProperties.getProperty(key);
        if (StringUtils.isBlank((CharSequence)stringProperty)) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "domain_count in property is empty");
            return 0;
        }
        return Integer.parseInt(stringProperty);
    }

    @Override
    public void refreshMaskTask() {
        this.scheduledExecutorService.scheduleAtFixedRate(this::refreshMaskTaskRunnable, 1800L, 7200L, TimeUnit.SECONDS);
    }

    private void refreshMaskTaskRunnable() {
        try {
            this.cryptoApiInstance.refreshMkMask();
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "refreshMaskTask success");
        }
        catch (AppException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "cryptoApiInstance.refreshMkMask error", (Throwable)e);
        }
    }

    @Override
    public void updateMainKey() {
        this.domainCount = this.getPropertyInteger("domain_count");
        this.scheduledExecutorService.scheduleAtFixedRate(this::updateMainKeyRunnable, 60L, 14400L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMainKeyRunnable() {
        try {
            Object object = this.lock;
            synchronized (object) {
                for (int num = 0; num < this.domainCount; ++num) {
                    this.cryptoApiInstance.checkAndUpdateMk(num, this.getPropertyInteger("crypt_key_lifetime_days"));
                }
            }
        }
        catch (AppException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "cryptoApiInstance.checkAndUpdateMk error", (Throwable)e);
        }
    }

    @Override
    public void finalized() {
        try {
            this.cryptoApiInstance.finalized();
        }
        catch (AppException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "cryptoApiInstance.finalized error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getKeyManageInfo() {
        ArrayList mkInfos = Lists.newArrayList();
        try {
            Object object = this.lock;
            synchronized (object) {
                int mkCount = this.cryptoApiInstance.getMkCount();
                for (int num = 0; num < mkCount; ++num) {
                    KmcMkInfo mkInfo = this.cryptoApiInstance.getMkInfo(num);
                    if (mkInfo == null) {
                        SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "getKeyManageInfo skip domain %d", num));
                        continue;
                    }
                    mkInfos.add(mkInfo);
                }
            }
        }
        catch (AppException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "AppException", (Throwable)e);
        }
        return JSON.toJSONString((Object)mkInfos);
    }

    @Override
    public void updateRootKey() {
        this.scheduledExecutorService.scheduleAtFixedRate(this::updateRootKeyRunnable, 1800L, 31536000L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRootKeyRunnable() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.cryptoApiInstance.updateRootKey();
                SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "updateRootKey Success");
            }
        }
        catch (AppException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "updateRootKey AppException", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeKeyByKeyId(int domainId, int keyId) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.cryptoApiInstance.removeKeyByKeyID(domainId, keyId);
            }
        }
        catch (AppException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "cryptoApiInstance.removeKeyByKeyID", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secureEraseKeystore() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.cryptoApiInstance.secureEraseKeystore();
            }
        }
        catch (AppException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "cryptoApiInstance.secureEraseKeystore", (Throwable)e);
        }
    }

    @Override
    public Object getInstance() {
        return this.cryptoApiInstance;
    }

    private Properties getSecurityProperties(Properties properties) throws KmcPropertiesException {
        if (properties == null || properties.isEmpty()) {
            throw new KmcPropertiesException("KMC properties is null");
        }
        Properties securityDoc = new Properties();
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            Object value = entry.getValue();
            Object key = entry.getKey();
            if (!(value instanceof String) || !(key instanceof String)) continue;
            KmcPropertiesValidate kmcPropertiesValidateEnum = KmcPropertiesValidate.getKmcPropertiesValidateEnum((String)key, (String)value);
            if (kmcPropertiesValidateEnum == null) {
                SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "this properties : %s is not Kmc necessary", (String)key));
                continue;
            }
            securityDoc.setProperty((String)key, kmcPropertiesValidateEnum.getRightPropertyValue());
        }
        return securityDoc;
    }

    private void setKmcFilePermission() {
        this.setFilePermission(this.securityProperties.getProperty("primary_key_store_file"));
        this.setFilePermission(this.securityProperties.getProperty("standby_key_store_file"));
        this.setFilePermission(this.securityProperties.getProperty("backupPath"));
    }

    private void setFilePermission(String filePath) {
        boolean isWritable;
        boolean isReadable;
        boolean isExecutable;
        File file = FileUtils.getFile((String[])new String[]{filePath});
        if (!file.exists()) {
            return;
        }
        if (!file.canExecute() && !(isExecutable = file.setExecutable(true, false))) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "setExecutable fail {0}", new Object[]{file.getName()});
        }
        if (!file.canRead() && !(isReadable = file.setReadable(true, false))) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "setReadable fail {0}", new Object[]{file.getName()});
        }
        if (!file.canWrite() && !(isWritable = file.setWritable(true, false))) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "setWritable fail {0}", new Object[]{file.getName()});
        }
    }
}

