/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.ics.common.adapter.encryption.service.kmc.common;

import com.huawei.kmc.common.ILogger;
import com.huawei.support.icscbb.log.common.service.SecurityLogUtils;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;

public class KmcLogger
extends ILogger {
    private static final String IN_KMC = "{0} [In KMC] {1} ";

    private String getCaller(String errorLevel) {
        StackTraceElement[] arr = new Throwable().getStackTrace();
        StringBuilder sb = new StringBuilder(1024);
        String currentThreadName = Thread.currentThread().getName();
        String className = arr[2].getClassName();
        String methodName = arr[2].getMethodName();
        int lineNumber = arr[2].getLineNumber();
        sb.append(this.getDate()).append(" [ ").append(currentThreadName).append(" ] ").append(errorLevel).append(" ").append(className).append(':').append(methodName).append('(').append(lineNumber).append(')');
        return sb.toString();
    }

    private String getDate() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Date.from(Instant.now()));
    }

    public void debug(String message) {
        SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", IN_KMC, new Object[]{this.getCaller("debug"), message});
    }

    public void info(String message) {
        SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", IN_KMC, new Object[]{this.getCaller("info"), message});
    }

    public void warn(String message) {
        SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", IN_KMC, new Object[]{this.getCaller("warn"), message});
    }

    public void error(String message) {
        SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", IN_KMC, new Object[]{this.getCaller("error"), message});
    }

    public void trace(String message) {
        SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", IN_KMC, new Object[]{this.getCaller("trace"), message});
    }
}

