/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.ics.common.adapter.encryption.service.kmc.common;

import com.alibaba.fastjson.JSON;
import com.google.common.eventbus.AsyncEventBus;
import com.huawei.kmc.common.INotifyCallback;
import com.huawei.kmc.common.KmcMkInfo;
import com.huawei.support.ics.common.adapter.encryption.service.util.EncryptionFileUtils;
import com.huawei.support.icscbb.log.common.service.SecurityLogUtils;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.commons.io.FileUtils;

public class KmcNotifyCallback
implements INotifyCallback {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss");
    private String backupPath;
    private AsyncEventBus eventBus;
    private int mkUpdateNum;

    public KmcNotifyCallback(String backupPath, AsyncEventBus eventBus, int mkUpdateNum) {
        this.backupPath = backupPath;
        this.eventBus = eventBus;
        this.mkUpdateNum = mkUpdateNum;
    }

    public void updateKsfDone(String src) {
        if (!EncryptionFileUtils.createDirectory(this.backupPath + File.separator)) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "create dir for backup ks error");
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        String prefix = now.format(DATE_FORMAT);
        int idx = 0;
        String backupFileName = prefix + "_" + idx + "_backup";
        String backupFile = this.backupPath + File.separator + backupFileName;
        File fileBackupFile = FileUtils.getFile((String[])new String[]{backupFile});
        while (EncryptionFileUtils.checkFile(fileBackupFile)) {
            backupFileName = prefix + "_" + ++idx + "_backup";
            backupFile = this.backupPath + File.separator + backupFileName;
            fileBackupFile = FileUtils.getFile((String[])new String[]{backupFile});
        }
        if (fileBackupFile == null) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "%s fileBackupFile is null", backupFileName));
            return;
        }
        File fileSrc = FileUtils.getFile((String[])new String[]{src});
        if (fileSrc == null) {
            return;
        }
        boolean isCopyFile = EncryptionFileUtils.copyFile(fileSrc, fileBackupFile);
        if (isCopyFile) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "%s kmc fileBackup success", backupFileName));
            EncryptionFileUtils.deleteFileNoLatest(this.backupPath, backupFileName);
        }
    }

    public void mkHasChanged(KmcMkInfo mk) {
        if (mk == null) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "mk info is null");
            return;
        }
        if (mk.getKeyId() == 1L && mk.getStatus() != 0) {
            return;
        }
        ++this.mkUpdateNum;
        if (mk.getStatus() == 0 && this.mkUpdateNum == 2) {
            this.eventBus.post((Object)mk);
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "domain " + mk.getDomainId() + " send key update info success");
            this.mkUpdateNum = 0;
        } else if (mk.getStatus() == 2 && this.mkUpdateNum == 1) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "mkHasChanged mk is update %s", JSON.toJSONString((Object)mk)));
        }
    }
}

