/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.ics.common.adapter.encryption.service.kmc.common;

import com.huawei.support.ics.common.adapter.encryption.service.kmc.exception.KmcPropertiesException;
import com.huawei.support.icscbb.log.common.service.SecurityLogUtils;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public enum KmcPropertiesValidate {
    PRIMARY_KEY_STORE_FILE("primary_key_store_file", KmcPropertiesValidate.getRegxRule("primary_key_store_file"), null),
    STANDBY_KEY_STORE_FILE_KEY("standby_key_store_file", KmcPropertiesValidate.getRegxRule("standby_key_store_file"), null),
    BACKUP_FOLDER_NAME("backupFolderName", KmcPropertiesValidate.getRegxRule("backupFolderName"), null),
    KMC_DLL_LIB_ABSOLUTE_PATH("kmcDllLibAbsolutePath", KmcPropertiesValidate.getRegxRule("kmcDllLibAbsolutePath"), null),
    CRYPT_ROOT_KEY_UPDATE_ENABLED("crypt_rootkey_update_enabled", KmcPropertiesValidate.getRegxRule("crypt_rootkey_update_enabled"), null),
    CRYPT_ROOT_KEY_LIFETIME_DAYS("crypt_rootkey_lifetime_days", KmcPropertiesValidate.getRegxRule("crypt_rootkey_lifetime_days"), null),
    AUTO_UPDATE_MK_ENABLED("auto_update_mk_enabled", KmcPropertiesValidate.getRegxRule("auto_update_mk_enabled"), null),
    CRYPT_KEY_LIFETIME_DAYS("crypt_key_lifetime_days", KmcPropertiesValidate.getRegxRule("crypt_key_lifetime_days"), null),
    CRYPT_SYMMETRIC_ALGORITHM("crypt_symmetric_algorithm", KmcPropertiesValidate.getRegxRule("crypt_symmetric_algorithm"), null),
    CRYPT_PROC_SEM_KEY("crypt_proc_sem_key", KmcPropertiesValidate.getRegxRule("crypt_proc_sem_key"), null),
    CRYPT_PROCESS_PERMS("crypt_process_perms", KmcPropertiesValidate.getRegxRule("crypt_process_perms"), null),
    CRYPT_COMPONENT_ROLE("crypt_component_role", KmcPropertiesValidate.getRegxRule("crypt_component_role"), null),
    CRYPT_HAMC_ALGORITHM("crypt_hamc_algorithm", KmcPropertiesValidate.getRegxRule("crypt_hamc_algorithm"), null),
    DOMAIN_COUNT("domain_count", KmcPropertiesValidate.getRegxRule("domain_count"), null),
    BACK_UP_PATH("backupPath", KmcPropertiesValidate.getRegxRule("backupPath"), null);

    private final String propertyName;
    private final String regExRule;
    private String rightPropertyValue;

    private KmcPropertiesValidate(String propertyName, String regExRule, String rightPropertyValue) {
        this.propertyName = propertyName;
        this.regExRule = regExRule;
        this.rightPropertyValue = rightPropertyValue;
    }

    public static KmcPropertiesValidate getKmcPropertiesValidateEnum(String propertyName, String propertyValue) throws KmcPropertiesException {
        boolean isValidate;
        String trimPropertyValue;
        HashMap<String, KmcPropertiesValidate> kmcPropertiesValidateHashMap = new HashMap<String, KmcPropertiesValidate>();
        kmcPropertiesValidateHashMap.put("primary_key_store_file", PRIMARY_KEY_STORE_FILE);
        kmcPropertiesValidateHashMap.put("standby_key_store_file", STANDBY_KEY_STORE_FILE_KEY);
        kmcPropertiesValidateHashMap.put("backupFolderName", BACKUP_FOLDER_NAME);
        kmcPropertiesValidateHashMap.put("kmcDllLibAbsolutePath", KMC_DLL_LIB_ABSOLUTE_PATH);
        kmcPropertiesValidateHashMap.put("crypt_rootkey_update_enabled", CRYPT_ROOT_KEY_UPDATE_ENABLED);
        kmcPropertiesValidateHashMap.put("crypt_rootkey_lifetime_days", CRYPT_ROOT_KEY_LIFETIME_DAYS);
        kmcPropertiesValidateHashMap.put("auto_update_mk_enabled", AUTO_UPDATE_MK_ENABLED);
        kmcPropertiesValidateHashMap.put("crypt_key_lifetime_days", CRYPT_KEY_LIFETIME_DAYS);
        kmcPropertiesValidateHashMap.put("crypt_symmetric_algorithm", CRYPT_SYMMETRIC_ALGORITHM);
        kmcPropertiesValidateHashMap.put("crypt_proc_sem_key", CRYPT_PROC_SEM_KEY);
        kmcPropertiesValidateHashMap.put("crypt_process_perms", CRYPT_PROCESS_PERMS);
        kmcPropertiesValidateHashMap.put("crypt_component_role", CRYPT_COMPONENT_ROLE);
        kmcPropertiesValidateHashMap.put("crypt_hamc_algorithm", CRYPT_HAMC_ALGORITHM);
        kmcPropertiesValidateHashMap.put("domain_count", DOMAIN_COUNT);
        kmcPropertiesValidateHashMap.put("backupPath", BACK_UP_PATH);
        KmcPropertiesValidate kmcPropertiesValidateEnum = (KmcPropertiesValidate)((Object)kmcPropertiesValidateHashMap.get(propertyName));
        if (kmcPropertiesValidateEnum == null) {
            return kmcPropertiesValidateEnum;
        }
        String charsNormalPropertyValue = trimPropertyValue = KmcPropertiesValidate.charsDeleteSpaces(propertyValue);
        if (StringUtils.equalsAny((CharSequence)propertyName, (CharSequence[])new CharSequence[]{"primary_key_store_file", "standby_key_store_file", "backupFolderName", "kmcDllLibAbsolutePath"})) {
            charsNormalPropertyValue = KmcPropertiesValidate.charsNormal(trimPropertyValue);
        }
        if (isValidate = KmcPropertiesValidate.regExValidate(charsNormalPropertyValue, kmcPropertiesValidateEnum.regExRule)) {
            kmcPropertiesValidateEnum.rightPropertyValue = charsNormalPropertyValue;
            return kmcPropertiesValidateEnum;
        }
        SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "this properties : %s  verification fails", propertyName));
        throw new KmcPropertiesException(propertyName + "KMC property verification fails");
    }

    private static String getRegxRule(String key) {
        HashMap<String, String> regxRuleMap = new HashMap<String, String>();
        String pathRegRule = "^[A-z]:\\\\[^|><?*\":\\/]*$";
        regxRuleMap.put("primary_key_store_file", pathRegRule);
        regxRuleMap.put("backupPath", pathRegRule);
        regxRuleMap.put("standby_key_store_file", pathRegRule);
        regxRuleMap.put("backupFolderName", pathRegRule);
        regxRuleMap.put("kmcDllLibAbsolutePath", pathRegRule);
        regxRuleMap.put("crypt_rootkey_update_enabled", "(true|false)$");
        regxRuleMap.put("crypt_rootkey_lifetime_days", "^(1[0-7]\\d|180|[1-9]\\d|[1-9])$");
        regxRuleMap.put("auto_update_mk_enabled", "(true|false)$");
        regxRuleMap.put("crypt_key_lifetime_days", "^(1[0-7]\\d|180|[1-9]\\d|[1-9])$");
        regxRuleMap.put("crypt_symmetric_algorithm", "((AES128_CBC)|(AES256_CBC)|(AES128_GCM)|(AES256_GCM))$");
        regxRuleMap.put("crypt_proc_sem_key", "^0x2016[1-9]{4}$");
        regxRuleMap.put("crypt_process_perms", "^[0-7]{4}$");
        regxRuleMap.put("crypt_component_role", "^(0|1)$");
        regxRuleMap.put("crypt_hamc_algorithm", "((HMAC_SHA256)|(HMAC_SHA384)|(HMAC_SHA512))$");
        regxRuleMap.put("domain_count", "^([2-9]|[1-9]\\d|[1-9]\\d{2}|10[0-2][0-3])$");
        return (String)regxRuleMap.get(key);
    }

    private static boolean regExValidate(String validateTargetStr, String regExRule) {
        Pattern pattern = Pattern.compile(regExRule);
        Matcher matcher = pattern.matcher(validateTargetStr);
        return matcher.matches();
    }

    private static String charsNormal(String propertyValue) {
        return Normalizer.normalize(propertyValue, Normalizer.Form.NFC);
    }

    private static String charsDeleteSpaces(String propertyValue) {
        return StringUtils.trim((String)propertyValue);
    }

    public String getRightPropertyValue() {
        return this.rightPropertyValue;
    }
}

