/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.ics.common.adapter.encryption.service.util;

import com.huawei.support.ics.common.adapter.encryption.service.util.SecureDirDetector;
import com.huawei.support.icscbb.log.common.service.SecurityLogUtils;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class EncryptionFileUtils {
    private EncryptionFileUtils() {
    }

    public static boolean checkFile(File targetFile) {
        if (targetFile == null) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "targetFile check result is null.");
            return false;
        }
        String targetFileName = targetFile.getName();
        if (targetFile.exists() && targetFile.isFile()) {
            return true;
        }
        if (!targetFile.exists()) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "targetFile :%s not existed", targetFileName));
            return false;
        }
        SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "%s :is not file", targetFileName));
        return false;
    }

    public static boolean createDirectory(String descDirName) {
        File descDir;
        String descDirNames = descDirName;
        if (!descDirNames.endsWith(File.separator)) {
            descDirNames = descDirNames + File.separator;
        }
        if ((descDir = FileUtils.getFile((String[])new String[]{descDirNames})) == null) {
            return false;
        }
        String dirName = descDir.getName();
        if (descDir.exists()) {
            return true;
        }
        if (descDir.mkdirs()) {
            try {
                SecureDirDetector.alterPermission(descDir.getCanonicalPath(), true);
            }
            catch (IOException e) {
                SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "EncryptionFileUtils.createDirectory() change %s dir permission error", dirName));
                return false;
            }
            return true;
        }
        SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "EncryptionFileUtils.createDirectory() created dir:%s error", dirName));
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(File source, File dest) {
        try (FileChannel sourceChannel = FileUtils.openInputStream((File)source).getChannel();
             FileChannel destChannel = FileUtils.openOutputStream((File)dest).getChannel();){
            if (destChannel != null && sourceChannel != null) {
                destChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "EncryptionFileUtils.copyFile() copy %s File error IOException", source.getName()));
        }
        SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, "EncryptionFileUtils.copyFile() copy %s File error", source.getName()));
        return false;
    }

    public static void deleteFileNoLatest(String dirs, String latestFileName) {
        File folder = FileUtils.getFile((String[])new String[]{dirs});
        if (folder == null) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "EncryptionFileUtils.deleteFileNoLatest(): dir is null");
            return;
        }
        Object[] list = folder.listFiles();
        if (ArrayUtils.isEmpty((Object[])list)) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "EncryptionFileUtils.deleteFileNoLatest(): list is empty");
            return;
        }
        LinkedList<Object> fileQueue = new LinkedList<Object>();
        fileQueue.add(folder);
        while (!fileQueue.isEmpty()) {
            Object[] files;
            File dir = (File)fileQueue.poll();
            if (dir == null || ArrayUtils.isEmpty((Object[])(files = dir.listFiles()))) continue;
            for (Object file : files) {
                if (((File)file).isFile()) {
                    if (StringUtils.equals((CharSequence)((File)file).getName(), (CharSequence)latestFileName)) continue;
                    boolean isDelete = ((File)file).delete();
                    SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", String.format(Locale.ENGLISH, isDelete ? "%s : is deleted success" : "%s : is deleted failed", ((File)file).getName()));
                    continue;
                }
                fileQueue.add(file);
            }
        }
    }
}

