/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.ics.common.adapter.encryption.service.util;

import com.huawei.support.icscbb.log.common.service.SecurityLogUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class HmacSha256Utils {
    private static final int MAC_LENGTH = 44;
    private static final String ALGORITHM = "HmacSHA256";

    public static String validateMac(String cipherKeyWithMac, String macGenerator) {
        String encryptStr;
        String generateMac;
        String encrypt = "";
        if (StringUtils.isBlank((CharSequence)cipherKeyWithMac)) {
            return encrypt;
        }
        if (macGenerator.length() < 44) {
            return encrypt;
        }
        String mac = cipherKeyWithMac.substring(0, 44);
        if (StringUtils.equals((CharSequence)mac, (CharSequence)(generateMac = HmacSha256Utils.generateMac(encryptStr = cipherKeyWithMac.substring(44), macGenerator)))) {
            encrypt = encryptStr;
        }
        return encrypt;
    }

    public static String addMac(String cipherKey, String macGenerator) {
        String macCipherKey = "";
        String mac = HmacSha256Utils.generateMac(cipherKey, macGenerator);
        if (StringUtils.isBlank((CharSequence)mac)) {
            return macCipherKey;
        }
        return mac + cipherKey;
    }

    public static byte[] generateMac(byte[] inputBytes, String macGenerator) {
        byte[] key = Base64.decodeBase64((String)macGenerator);
        SecretKeySpec secretKey = new SecretKeySpec(key, ALGORITHM);
        byte[] macBytes = new byte[]{};
        try {
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            byte[] digest = mac.doFinal(inputBytes);
            if (digest == null || digest.length == 0) {
                return macBytes;
            }
            macBytes = digest;
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
            SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "GenerateMac error", (Throwable)e);
        }
        return macBytes;
    }

    public static String generateMac(String inputBytes, String macGenerator) {
        return Base64.encodeBase64String((byte[])HmacSha256Utils.generateMac(inputBytes.getBytes(StandardCharsets.UTF_8), macGenerator));
    }
}

