/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.ics.common.adapter.encryption.service.util;

import com.huawei.support.icscbb.log.common.service.SecurityLogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Locale;
import java.util.Set;

public class SecureDirDetector {
    private SecureDirDetector() {
    }

    public static void alterPermission(String path, boolean isDir) {
        String osName = System.getProperty("os.name");
        if (osName != null && !osName.toLowerCase(Locale.ENGLISH).contains("windows")) {
            Set<PosixFilePermission> perms = isDir ? PosixFilePermissions.fromString("rwx------") : PosixFilePermissions.fromString("rw-------");
            try {
                Files.setPosixFilePermissions(Paths.get(path, new String[0]), perms);
            }
            catch (IOException e) {
                SecurityLogUtils.INSTANCE.securityLog("CommonAdapterService-encryption-service", "alter permission failed");
            }
        }
    }
}

