/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.bloom;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsQueryDto;
import com.huawei.support.icscbb.commonsearch.index.entity.LibBaseDo;
import com.huawei.support.icscbb.commonsearch.index.query.HwIcsMetaQuery;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.SearchField;
import com.huawei.support.icscbb.commonsearch.lucene.search.exception.SearchException;
import com.huawei.support.icscbb.commonsearch.lucene.search.service.SearchManagerBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.util.SearchUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.document.Document;
import org.xml.sax.Attributes;

public abstract class BloomFilterHandler {
    protected static final int BLOOM_FILTER_EXPECTED_INSERTIONS = 300000;
    protected static final double BLOOM_FILTER_FPP = 1.0E-5;
    protected static final float ICSINDEX_BOOST = 1.0f;
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(BloomFilterHandler.class);
    private final BloomFilter<String> topicIdBloomFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)StandardCharsets.UTF_8), (int)300000, (double)1.0E-5);

    public boolean contains(Attributes attributes) {
        return this.topicIdBloomFilter.mightContain((Object)this.getKey(attributes));
    }

    public void init(LibBaseDo libBaseDo) {
        String indexDir = libBaseDo.getIndexDir();
        if (!FileUtils.getFile((String[])new String[]{indexDir}).exists()) {
            return;
        }
        try {
            List<Document> documents = new SearchManagerBase().searchDocuments(new HwIcsQueryDto(libBaseDo.getLibId(), libBaseDo.getIndexLang(), this.getSearchField()), new HwIcsMetaQuery(), SearchUtils.getIndexDirs(indexDir, Runtime.getRuntime().availableProcessors()));
            if (CollectionUtils.isEmpty(documents)) {
                return;
            }
            documents.forEach(document -> this.topicIdBloomFilter.put((Object)this.getKey((Document)document)));
            CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index]There are {0} documents are already indexed in old index.", new Object[]{documents.size()});
        }
        catch (SearchException | IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]There may be no old index.", (Throwable)e);
        }
    }

    protected abstract String getKey(Document var1);

    protected abstract String getKey(Attributes var1);

    protected abstract SearchField getSearchField();
}

