/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.chain;

import com.huawei.support.icscbb.util.xml.context.ParserContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;

public abstract class AbstractIndexProcessChain {
    private static final List<String> SYNC_DOC_SUFFIX_LIST = Collections.unmodifiableList(Arrays.asList(".ppt", ".pptx"));

    protected ParserContext getParserContext(Attributes attributes) {
        ParserContext parserContext = new ParserContext();
        IntStream.range(0, attributes.getLength()).mapToObj(attributes::getQName).forEach(attrName -> parserContext.add(attrName, (Object)attributes.getValue((String)attrName)));
        return parserContext;
    }

    protected void execute(ThreadPoolExecutor threadPool, Runnable runnable, String url) {
        if (runnable == null) {
            return;
        }
        if (this.isSyncDocumentType(url)) {
            runnable.run();
        } else {
            threadPool.execute(runnable);
        }
    }

    private boolean isSyncDocumentType(String topicUrl) {
        return SYNC_DOC_SUFFIX_LIST.stream().anyMatch(syncDoc -> StringUtils.endsWith((CharSequence)StringUtils.toRootLowerCase((String)topicUrl), (CharSequence)syncDoc));
    }
}

