/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.chain;

import com.huawei.support.icscbb.commonsearch.index.chain.IndexPrepareChain;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;
import org.xml.sax.Attributes;

public class CpuControlChain
implements IndexPrepareChain {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(CpuControlChain.class);
    private static final int DECIMAL_SCALE = 2;
    private static final int PERCENTAGE = 100;
    private static final OperatingSystemMXBean OPERATING_SYSTEM_MX_BEAN = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private int cpuSleepTime;
    private int cpuMaxThreshold;

    @Override
    public boolean process(Attributes attributes) {
        this.cpuSleep();
        return true;
    }

    private int getCpuUsage() {
        BigDecimal cpuLoadRate = new BigDecimal(String.valueOf(OPERATING_SYSTEM_MX_BEAN.getSystemCpuLoad()));
        return cpuLoadRate.setScale(2, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).intValue();
    }

    private void cpuSleep() {
        if (this.getCpuUsage() <= this.cpuMaxThreshold) {
            return;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(this.cpuSleepTime);
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Cpu Sleep error.", (Throwable)e);
        }
    }

    public CpuControlChain() {
    }

    public CpuControlChain(int cpuSleepTime, int cpuMaxThreshold) {
        this.cpuSleepTime = cpuSleepTime;
        this.cpuMaxThreshold = cpuMaxThreshold;
    }
}

