/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.chain;

import com.huawei.support.icscbb.commonsearch.index.chain.AbstractIndexProcessChain;
import com.huawei.support.icscbb.commonsearch.index.chain.IndexPrepareChain;
import com.huawei.support.icscbb.commonsearch.index.core.HdxTaskThread;
import com.huawei.support.icscbb.commonsearch.index.entity.HdxLibDo;
import com.huawei.support.icscbb.commonsearch.index.manager.HdxIndexManagerHandler;
import com.huawei.support.icscbb.commonsearch.index.template.help.IndexInfoManagerHandler;
import com.huawei.support.icscbb.commonsearch.index.template.help.SemaphoreHandler;
import com.huawei.support.icscbb.commonsearch.lucene.index.service.IndexManager;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.xml.sax.Attributes;

public class HdxIndexProcessChain
extends AbstractIndexProcessChain
implements IndexPrepareChain {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxIndexProcessChain.class);
    private HdxIndexManagerHandler indexManagerHandler;
    private ThreadPoolExecutor threadPool;
    private HdxLibDo hdxLibDo;
    private SemaphoreHandler semaphoreHandler;
    private IndexInfoManagerHandler indexInfoManagerHandler;

    @Override
    public boolean process(Attributes attributes) {
        if (this.hdxLibDo == null) {
            return false;
        }
        this.execute(this.threadPool, this.createThread(attributes), attributes.getValue("url"));
        return true;
    }

    private Runnable createThread(Attributes attributes) {
        IndexManager indexManager = null;
        try {
            indexManager = this.indexManagerHandler.get(this.hdxLibDo.getDocId());
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get index manager error.", (Throwable)e);
        }
        if (indexManager == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Not thread process.");
            return null;
        }
        this.semaphoreHandler.acquire();
        return new HdxTaskThread().setIndexManager(indexManager).setParserContext(this.getParserContext(attributes)).setHdxIndexManagerHandler(this.indexManagerHandler).setHdxLibDo(this.hdxLibDo).setSemaphoreHandler(this.semaphoreHandler).setIndexInfoManagerHandler(this.indexInfoManagerHandler);
    }

    public HdxIndexProcessChain setIndexManagerHandler(HdxIndexManagerHandler indexManagerHandler) {
        this.indexManagerHandler = indexManagerHandler;
        return this;
    }

    public HdxIndexProcessChain setThreadPool(ThreadPoolExecutor threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public HdxIndexProcessChain setHdxLibDo(HdxLibDo hdxLibDo) {
        this.hdxLibDo = hdxLibDo;
        return this;
    }

    public HdxIndexProcessChain setSemaphoreHandler(SemaphoreHandler semaphoreHandler) {
        this.semaphoreHandler = semaphoreHandler;
        return this;
    }

    public HdxIndexProcessChain setIndexInfoManagerHandler(IndexInfoManagerHandler indexInfoManagerHandler) {
        this.indexInfoManagerHandler = indexInfoManagerHandler;
        return this;
    }
}

