/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.chain;

import com.huawei.support.icscbb.commonsearch.index.chain.AbstractIndexProcessChain;
import com.huawei.support.icscbb.commonsearch.index.chain.IndexPrepareChain;
import com.huawei.support.icscbb.commonsearch.index.core.IcsTaskThread;
import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsLibDo;
import com.huawei.support.icscbb.commonsearch.index.entity.MetaDo;
import com.huawei.support.icscbb.commonsearch.index.listener.impl.PidMetaHandler;
import com.huawei.support.icscbb.commonsearch.index.listener.impl.TopicMetaHandler;
import com.huawei.support.icscbb.commonsearch.index.manager.IcsIndexManagerHandler;
import com.huawei.support.icscbb.commonsearch.index.manager.IndexManagerHandler;
import com.huawei.support.icscbb.commonsearch.index.template.help.SemaphoreHandler;
import com.huawei.support.icscbb.commonsearch.lucene.index.service.IndexManager;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.xml.sax.Attributes;

public class IndexProcessChain
extends AbstractIndexProcessChain
implements IndexPrepareChain {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IndexProcessChain.class);
    private IndexManagerHandler indexManagerHandler;
    private ThreadPoolExecutor threadPool;
    private PidMetaHandler pidMetaHandler;
    private TopicMetaHandler topicMetaHandler;
    private HwIcsLibDo hwIcsLibDo;
    private SemaphoreHandler semaphoreHandler;

    @Override
    public boolean process(Attributes attributes) {
        this.execute(this.threadPool, this.createThread(attributes), this.getTopicUrl(attributes));
        return true;
    }

    private String getTopicUrl(Attributes attributes) {
        MetaDo metaDo = this.topicMetaHandler.query(attributes.getValue("refDocId"), attributes.getValue("id"));
        if (metaDo == null) {
            return "";
        }
        return metaDo.getUrl();
    }

    private Runnable createThread(Attributes attributes) {
        IndexManager indexManager = null;
        try {
            indexManager = this.indexManagerHandler.get(attributes.getValue("refDocId"));
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Get index manager error.", (Throwable)e);
        }
        if (indexManager == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Not thread process.");
            return null;
        }
        this.semaphoreHandler.acquire();
        return new IcsTaskThread().setIndexManager(indexManager).setParserContext(this.getParserContext(attributes)).setPidMetaHandler(this.pidMetaHandler).setTopicMetaHandler(this.topicMetaHandler).setIcsIndexManagerHandler((IcsIndexManagerHandler)this.indexManagerHandler).setHwIcsLibDo(this.hwIcsLibDo).setSemaphoreHandler(this.semaphoreHandler);
    }

    public IndexProcessChain setIndexManagerHandler(IndexManagerHandler indexManagerHandler) {
        this.indexManagerHandler = indexManagerHandler;
        return this;
    }

    public IndexProcessChain setThreadPool(ThreadPoolExecutor threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public IndexProcessChain setPidMetaHandler(PidMetaHandler pidMetaHandler) {
        this.pidMetaHandler = pidMetaHandler;
        return this;
    }

    public IndexProcessChain setTopicMetaHandler(TopicMetaHandler topicMetaHandler) {
        this.topicMetaHandler = topicMetaHandler;
        return this;
    }

    public IndexProcessChain setHwIcsLibDo(HwIcsLibDo hwIcsLibDo) {
        this.hwIcsLibDo = hwIcsLibDo;
        return this;
    }

    public IndexProcessChain setSemaphoreHandler(SemaphoreHandler semaphoreHandler) {
        this.semaphoreHandler = semaphoreHandler;
        return this;
    }
}

