/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.core;

import com.huawei.support.icscbb.commonsearch.index.entity.HdxLibDo;
import com.huawei.support.icscbb.commonsearch.index.entity.HdxNaviDto;
import com.huawei.support.icscbb.commonsearch.index.manager.HdxIndexManagerHandler;
import com.huawei.support.icscbb.commonsearch.index.parser.DocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.ParserFactory;
import com.huawei.support.icscbb.commonsearch.index.template.help.IndexInfoManagerHandler;
import com.huawei.support.icscbb.commonsearch.index.template.help.SemaphoreHandler;
import com.huawei.support.icscbb.commonsearch.lucene.index.exception.IndexException;
import com.huawei.support.icscbb.commonsearch.lucene.index.service.IndexManager;
import com.huawei.support.icscbb.commonsearch.lucene.index.util.IndexUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.xml.context.ParserContext;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;

public class HdxTaskThread
implements Runnable {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxTaskThread.class);
    private IndexManager indexManager;
    private ParserContext parserContext;
    private HdxIndexManagerHandler hdxIndexManagerHandler;
    private HdxLibDo hdxLibDo;
    private SemaphoreHandler semaphoreHandler;
    private IndexInfoManagerHandler indexInfoManagerHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            HdxNaviDto hdxNaviDto = this.generateHdxNaviDto(this.parserContext);
            Document document = new Document();
            HdxLibDo actualHdxLibDo = this.getHdxLibInfoMap(hdxNaviDto.getLibId() + hdxNaviDto.getLibV());
            this.addLibInfo(actualHdxLibDo, document);
            if (!this.addTopicBaseInfo(actualHdxLibDo, hdxNaviDto, document)) {
                return;
            }
            this.addOtherFields(hdxNaviDto, document);
            this.indexManager.addDocument(document);
        }
        catch (IndexException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Add index error.", (Throwable)e);
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Hdx Parse topic or create index error.", (Throwable)e);
        }
        finally {
            this.hdxIndexManagerHandler.add(this.hdxLibDo.getDocId(), this.indexManager);
            this.indexInfoManagerHandler.update();
            this.semaphoreHandler.release();
        }
    }

    private HdxNaviDto generateHdxNaviDto(ParserContext paramParserContext) {
        String topicType = paramParserContext.getStringValue("topicType");
        HdxNaviDto hdxNaviDto = new HdxNaviDto();
        if (StringUtils.equals((CharSequence)"0", (CharSequence)topicType)) {
            hdxNaviDto.setId(paramParserContext.getStringValue("id"));
            hdxNaviDto.setTitle(paramParserContext.getStringValue("txt"));
            hdxNaviDto.setLibId(paramParserContext.getStringValue("libId"));
            hdxNaviDto.setLibV(paramParserContext.getStringValue("libVersion"));
            hdxNaviDto.setUrl(paramParserContext.getStringValue("url"));
            hdxNaviDto.setTopicType("0");
            hdxNaviDto.setTopicPath(paramParserContext.getStringValue("topicPath"));
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)topicType)) {
            hdxNaviDto.setLibId(this.hdxLibDo.getLibId());
            hdxNaviDto.setLibV(this.hdxLibDo.getLibV());
            hdxNaviDto.setUrl(paramParserContext.getStringValue("url"));
            hdxNaviDto.setTopicType("1");
        }
        return hdxNaviDto;
    }

    public HdxLibDo getHdxLibInfoMap(String mapKey) {
        if (StringUtils.equals((CharSequence)mapKey, (CharSequence)(this.hdxLibDo.getLibId() + this.hdxLibDo.getLibV()))) {
            return this.hdxLibDo;
        }
        HdxLibDo actualHdxLibDo = this.hdxLibDo.getHdxLibInfoMap().get(mapKey);
        if (actualHdxLibDo == null) {
            return this.hdxLibDo;
        }
        return actualHdxLibDo;
    }

    private void addLibInfo(HdxLibDo actualHdxLibDo, Document document) {
        this.addToDocument("docId", actualHdxLibDo.getDocId(), document);
        this.addToDocument("libId", actualHdxLibDo.getLibId(), document);
        this.addToDocument("libVer", actualHdxLibDo.getLibV(), document);
        this.addToDocument("libName", actualHdxLibDo.getLibName(), document);
        this.addToDocument("language", this.hdxLibDo.getLanguage(), document);
        this.addToDocument("productName", this.hdxLibDo.getProductName(), document);
        this.addToDocument("productV", this.hdxLibDo.getProductV(), document);
        this.addToDocument("issueDate", this.hdxLibDo.getIssueDate(), document);
    }

    private boolean addTopicBaseInfo(HdxLibDo actualHdxLibDo, HdxNaviDto naviDto, Document document) {
        String topicInZipPath = "resources/" + naviDto.getUrl();
        this.addTitleAndContent(actualHdxLibDo.getPath(), topicInZipPath, naviDto.getTitle(), document);
        return document.getFields().stream().noneMatch(field -> StringUtils.equals((CharSequence)field.name(), (CharSequence)"t_content") && StringUtils.isBlank((CharSequence)field.stringValue()));
    }

    private void addTitleAndContent(String docPath, String topicInZipPath, String title, Document document) {
        String docType = IndexUtils.getDocType(docPath, topicInZipPath);
        DocumentParser documentParser = ParserFactory.getInstance().get("hdxtask", docType);
        if (documentParser == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Not get parser, topicUrl:{0}-{1}", new Object[]{topicInZipPath, docType});
            return;
        }
        List<Field> extractList = documentParser.extract(topicInZipPath, docPath, title);
        extractList.forEach(arg_0 -> ((Document)document).add(arg_0));
    }

    private void addOtherFields(HdxNaviDto naviDto, Document document) {
        this.addToDocument("topicid", naviDto.getId(), document);
        this.addToDocument("topicidstring", naviDto.getId(), document, StringField.class.getSimpleName());
        this.addToDocument("topicurl", naviDto.getUrl(), document);
        this.addToDocument("navipath", naviDto.getTopicPath(), document);
        this.addToDocument("topictype", naviDto.getTopicType(), document);
    }

    private void addToDocument(String key, String value, Document document) {
        this.addToDocument(key, value, document, TextField.class.getSimpleName());
    }

    private void addToDocument(String key, String value, Document document, String className) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        document.add((IndexableField)IndexUtils.getField(key, value, Field.Store.YES, className));
    }

    public HdxTaskThread setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
        return this;
    }

    public HdxTaskThread setParserContext(ParserContext parserContext) {
        this.parserContext = parserContext;
        return this;
    }

    public HdxTaskThread setHdxIndexManagerHandler(HdxIndexManagerHandler hdxIndexManagerHandler) {
        this.hdxIndexManagerHandler = hdxIndexManagerHandler;
        return this;
    }

    public HdxTaskThread setHdxLibDo(HdxLibDo hdxLibDo) {
        this.hdxLibDo = hdxLibDo;
        return this;
    }

    public HdxTaskThread setSemaphoreHandler(SemaphoreHandler semaphoreHandler) {
        this.semaphoreHandler = semaphoreHandler;
        return this;
    }

    public HdxTaskThread setIndexInfoManagerHandler(IndexInfoManagerHandler indexInfoManagerHandler) {
        this.indexInfoManagerHandler = indexInfoManagerHandler;
        return this;
    }
}

