/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.core;

import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsLibDo;
import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsRelationDo;
import com.huawei.support.icscbb.commonsearch.index.entity.MetaDo;
import com.huawei.support.icscbb.commonsearch.index.entity.MetaExtDo;
import com.huawei.support.icscbb.commonsearch.index.entity.PropertyDo;
import com.huawei.support.icscbb.commonsearch.index.listener.impl.PidMetaHandler;
import com.huawei.support.icscbb.commonsearch.index.listener.impl.TopicMetaHandler;
import com.huawei.support.icscbb.commonsearch.index.manager.IcsIndexManagerHandler;
import com.huawei.support.icscbb.commonsearch.index.parser.DocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.ParserFactory;
import com.huawei.support.icscbb.commonsearch.index.template.help.SemaphoreHandler;
import com.huawei.support.icscbb.commonsearch.index.util.IndexMetaUtils;
import com.huawei.support.icscbb.commonsearch.lucene.index.exception.IndexException;
import com.huawei.support.icscbb.commonsearch.lucene.index.service.IndexManager;
import com.huawei.support.icscbb.commonsearch.lucene.index.util.IndexUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.xml.context.ParserContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;

public class IcsTaskThread
implements Runnable {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsTaskThread.class);
    private static final String INDEX_TERM_START_TOPIC_TAG = "tt_";
    private IndexManager indexManager;
    private ParserContext parserContext;
    private PidMetaHandler pidMetaHandler;
    private TopicMetaHandler topicMetaHandler;
    private IcsIndexManagerHandler icsIndexManagerHandler;
    private HwIcsLibDo hwIcsLibDo;
    private SemaphoreHandler semaphoreHandler;

    @Override
    public void run() {
        try {
            Document document = new Document();
            if (!this.addTopicMetaInfo(document)) {
                return;
            }
            if (!this.addPidMetaInfo(document)) {
                return;
            }
            IndexMetaUtils.addProfileToDocument(this.hwIcsLibDo, document);
            this.indexManager.addDocument(document);
        }
        catch (IndexException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Add index error.", (Throwable)e);
        }
        catch (Exception e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Parse topic or create index error.", (Throwable)e);
        }
        finally {
            this.icsIndexManagerHandler.add(this.parserContext.getStringValue("refDocId"), this.indexManager);
            this.semaphoreHandler.release();
        }
    }

    private boolean addTopicMetaInfo(Document document) {
        String topicId = this.parserContext.getStringValue("id");
        String refDocId = this.parserContext.getStringValue("refDocId");
        MetaDo topicMetaDo = this.topicMetaHandler.query(refDocId, topicId);
        Optional<String> urlOption = Optional.ofNullable(topicMetaDo).map(MetaDo::getUrl).filter(StringUtils::isNotBlank);
        if (!urlOption.isPresent()) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Topic meta or url is not configured.");
            return false;
        }
        String url = urlOption.get();
        IndexMetaUtils.addToDocument("t_id", topicId, document);
        IndexMetaUtils.addToDocument("t_url", url, document);
        IndexMetaUtils.addToDocument("t_position", this.parserContext.getStringValue("position"), document);
        IndexMetaUtils.addToDocument("t_topicpath", this.parserContext.getStringValue("path"), document);
        String libPath = this.getLibPathOfTopic(refDocId);
        String resRelativeUrl = "resources/" + url;
        DocumentParser documentParser = ParserFactory.getInstance().get("hwicstask", IndexUtils.getDocType(libPath, resRelativeUrl));
        if (documentParser == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Not get parser, topicUrl:{0}", new Object[]{url});
            return false;
        }
        documentParser.extract(resRelativeUrl, libPath, this.parserContext.getStringValue("name")).forEach(arg_0 -> ((Document)document).add(arg_0));
        this.addRefInfo(document);
        this.addIndexFieldToDocument(topicMetaDo, document);
        return true;
    }

    private void addDefaultMetaNameId(Document document) {
        List<String> filterMetaIds = Optional.ofNullable(this.hwIcsLibDo.getFilterMetaIds()).orElse(Collections.emptyList());
        filterMetaIds.forEach(filterMetaId -> {
            String id = INDEX_TERM_START_TOPIC_TAG + StringUtils.toRootLowerCase((String)filterMetaId);
            if (document.getField(id) == null) {
                IndexMetaUtils.addToDocument(id, "all", document);
            }
        });
    }

    private void addRefInfo(Document document) {
        Object[] parentDocIds = this.parserContext.getStringValue("parentDocIds").split(",");
        if (ArrayUtils.isEmpty((Object[])parentDocIds)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Exception doc, not exist refDocId.");
            return;
        }
        IndexMetaUtils.addToDocument("refflag", (String)parentDocIds[0], document);
        Arrays.stream(parentDocIds).forEach(docId -> IndexMetaUtils.addToDocument("s_reldocid", docId, document));
    }

    private String getLibPathOfTopic(String refDocId) {
        if (StringUtils.equals((CharSequence)this.hwIcsLibDo.getDocId(), (CharSequence)refDocId)) {
            return this.hwIcsLibDo.getPath();
        }
        List relationLibInfos = Optional.ofNullable(this.hwIcsLibDo.getRelationLibInfos()).orElse(new ArrayList());
        for (HwIcsRelationDo relationLibInfo : relationLibInfos) {
            if (!StringUtils.equals((CharSequence)relationLibInfo.getDocId(), (CharSequence)refDocId)) continue;
            return relationLibInfo.getPath();
        }
        return "";
    }

    private boolean addPidMetaInfo(Document document) {
        String pid = this.parserContext.getStringValue("pid");
        Optional<MetaExtDo> pidMetaExtDo = this.pidMetaHandler.queryExtMetaDo(this.hwIcsLibDo, pid);
        if (!pidMetaExtDo.isPresent()) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Pid meta is not configured.Pid:{0}", new Object[]{pid});
            return false;
        }
        MetaDo metaDo = pidMetaExtDo.get().getMetaDo();
        IndexMetaUtils.addToDocument("p_id", metaDo.getId(), document);
        IndexMetaUtils.addToDocument("p_name", metaDo.getName(), document);
        this.addIndexFieldToDocument(metaDo, document);
        return true;
    }

    private void addIndexFieldToDocument(MetaDo metaDo, Document document) {
        List propertyDoList = Optional.ofNullable(metaDo.getPropertyDoList()).orElse(new ArrayList());
        boolean exist = false;
        for (PropertyDo propertyDo : propertyDoList) {
            if (!exist && StringUtils.startsWith((CharSequence)propertyDo.getKey(), (CharSequence)INDEX_TERM_START_TOPIC_TAG)) {
                exist = true;
            }
            IndexMetaUtils.addToDocument(propertyDo.getKey(), propertyDo.getValue(), document);
        }
        if (!exist) {
            this.addDefaultMetaNameId(document);
        }
    }

    public IcsTaskThread setIndexManager(IndexManager indexManager) {
        this.indexManager = indexManager;
        return this;
    }

    public IcsTaskThread setParserContext(ParserContext parserContext) {
        this.parserContext = parserContext;
        return this;
    }

    public IcsTaskThread setPidMetaHandler(PidMetaHandler pidMetaHandler) {
        this.pidMetaHandler = pidMetaHandler;
        return this;
    }

    public IcsTaskThread setTopicMetaHandler(TopicMetaHandler topicMetaHandler) {
        this.topicMetaHandler = topicMetaHandler;
        return this;
    }

    public IcsTaskThread setIcsIndexManagerHandler(IcsIndexManagerHandler icsIndexManagerHandler) {
        this.icsIndexManagerHandler = icsIndexManagerHandler;
        return this;
    }

    public IcsTaskThread setHwIcsLibDo(HwIcsLibDo hwIcsLibDo) {
        this.hwIcsLibDo = hwIcsLibDo;
        return this;
    }

    public IcsTaskThread setSemaphoreHandler(SemaphoreHandler semaphoreHandler) {
        this.semaphoreHandler = semaphoreHandler;
        return this;
    }
}

