/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.listener.impl;

import com.alibaba.fastjson.JSON;
import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsLibDo;
import com.huawei.support.icscbb.commonsearch.index.entity.MetaDo;
import com.huawei.support.icscbb.commonsearch.index.entity.MetaExtDo;
import com.huawei.support.icscbb.commonsearch.index.entity.PidDo;
import com.huawei.support.icscbb.commonsearch.index.listener.impl.PidMetaHandler;
import com.huawei.support.icscbb.commonsearch.index.util.IndexMetaUtils;
import com.huawei.support.icscbb.commonsearch.lucene.index.exception.IndexException;
import com.huawei.support.icscbb.commonsearch.lucene.index.service.IndexManager;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.EventListener;
import com.huawei.support.icscbb.util.xml.context.ParserContext;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import com.huawei.support.icscbb.util.xml.sax.XmlSaxParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.BiConsumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocNaviHandler
implements EventListener {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(DocNaviHandler.class);
    private static final String DOC_NAV_PATH_FORMAT = "resources/infocenter_service/metadata/%s.xml";
    private static final String INDEX_DOCUMENT_TYPE = "type";
    private static final int MAX_PID_NUM = 4;
    private final PidMetaHandler pidMetaHandler;
    private final IndexManager indexManager;
    private final HwIcsLibDo hwIcsLibDo;
    private final List<PidDo> pidDos = new ArrayList<PidDo>();
    private final Stack<String> navPathStack = new Stack();
    private String docNavName;
    private String docNavId;
    private final Map<String, BiConsumer<String, Attributes>> nodeBiConsumerMap = this.getNodeBiConsumerMap();

    public DocNaviHandler(PidMetaHandler pidMetaHandler, IndexManager indexManager, HwIcsLibDo hwIcsLibDo) {
        this.pidMetaHandler = pidMetaHandler;
        this.indexManager = indexManager;
        this.hwIcsLibDo = hwIcsLibDo;
    }

    private Map<String, BiConsumer<String, Attributes>> getNodeBiConsumerMap() {
        HashMap<String, BiConsumer<String, Attributes>> functionMap = new HashMap<String, BiConsumer<String, Attributes>>();
        functionMap.put("docNav", this::parseDocNavNode);
        functionMap.put("navItem", this::parseNavItemNode);
        functionMap.put("docCategory", this::parseDocCategoryNode);
        functionMap.put("docstatic", this::parseDocStaticNode);
        functionMap.put("docdynamic", this::parseDocDynamicNode);
        return functionMap;
    }

    private void addPidDo(PidDo pidDo) {
        if (this.pidDos.size() < 4) {
            this.pidDos.add(pidDo);
        }
    }

    public void parser(String docNavId) {
        this.docNavId = docNavId;
        try (InputStream inputStream = ZipFilePool.getInputStream((String)this.hwIcsLibDo.getPath(), (String)String.format(Locale.ROOT, DOC_NAV_PATH_FORMAT, docNavId));){
            if (inputStream == null) {
                return;
            }
            XmlSaxParser xmlSaxParser = new XmlSaxParser((EventListener)this, new ParserContext());
            SAXParserUtils.parseXml((InputStream)inputStream, (DefaultHandler)xmlSaxParser);
            this.indexManager.addDocument(this.getDocNavDocument());
        }
        catch (IndexException | IOException | SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Create docNav index error.", (Throwable)e);
        }
    }

    private Document getDocNavDocument() {
        Document document = new Document();
        IndexMetaUtils.addToDocument("t_title", this.docNavName, document);
        IndexMetaUtils.addToDocument("docnavid", this.docNavId, document);
        this.pidDos.forEach(pidDo -> IndexMetaUtils.addToDocument("pIdEntity", JSON.toJSONString((Object)pidDo), document));
        IndexMetaUtils.addToDocument(INDEX_DOCUMENT_TYPE, "docNav", document);
        IndexMetaUtils.addProfileToDocument(this.hwIcsLibDo, document);
        return document;
    }

    public void invoke(String name, Attributes attributes, ParserContext parserContext) {
        BiConsumer<String, Attributes> biConsumer;
        String consumerKey = name;
        if (StringUtils.equals((CharSequence)name, (CharSequence)"doc")) {
            consumerKey = consumerKey + (String)StringUtils.defaultIfBlank((CharSequence)attributes.getValue(INDEX_DOCUMENT_TYPE), (CharSequence)"static");
        }
        if ((biConsumer = this.nodeBiConsumerMap.get(consumerKey)) != null) {
            biConsumer.accept(name, attributes);
        }
    }

    public void invokeAfter(String name, ParserContext parserContext) {
        if (CollectionUtils.isNotEmpty(this.navPathStack)) {
            this.navPathStack.pop();
        }
    }

    private void parseDocNavNode(String name, Attributes attributes) {
        this.docNavName = attributes.getValue(INDEX_DOCUMENT_TYPE);
        String docNavIdValue = attributes.getValue("id");
        if (StringUtils.isNotBlank((CharSequence)docNavIdValue)) {
            this.docNavId = docNavIdValue;
        }
        this.navPathStack.push(this.docNavName);
    }

    private void parseNavItemNode(String name, Attributes attributes) {
        this.navPathStack.push(attributes.getValue("value"));
    }

    private void parseDocCategoryNode(String name, Attributes attributes) {
        this.navPathStack.push(attributes.getValue("name"));
    }

    private void parseDocStaticNode(String name, Attributes attributes) {
        String pid = attributes.getValue("id");
        String pName = attributes.getValue("name");
        Optional<MetaExtDo> metaExtDoOpt = this.pidMetaHandler.queryExtMetaDo(this.hwIcsLibDo, pid);
        if (!metaExtDoOpt.isPresent()) {
            this.navPathStack.push(pName);
            return;
        }
        MetaExtDo metaExtDo = metaExtDoOpt.get();
        Optional<String> nameOpt = Optional.ofNullable(metaExtDo.getMetaDo()).map(MetaDo::getName);
        if (nameOpt.isPresent()) {
            pName = nameOpt.get();
        }
        this.navPathStack.push(pName);
        PidDo pidDo = new PidDo(pid, pName, this.createNavPath(), this.hwIcsLibDo.getDocId(), metaExtDo.getDocId());
        this.createPidDocument(pidDo, metaExtDo.getMetaDo());
        this.addPidDo(pidDo);
    }

    private void createPidDocument(PidDo pidDo, MetaDo metaDo) {
        Document pidDocument = this.getPidDocument(pidDo, metaDo);
        try {
            this.indexManager.addDocument(pidDocument);
        }
        catch (IndexException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Create pid index error.", (Throwable)e);
        }
    }

    private Document getPidDocument(PidDo pidDo, MetaDo metaDo) {
        Document document = new Document();
        IndexMetaUtils.addToDocument("p_id", pidDo.getId(), document);
        IndexMetaUtils.addToDocument("t_title", pidDo.getName(), document);
        IndexMetaUtils.addToDocument("t_topicpath", pidDo.getNavPath(), document);
        IndexMetaUtils.addToDocument("s_reldocid", pidDo.getRefDocId(), document);
        IndexMetaUtils.addToDocument("refflag", pidDo.getRefDocId(), document);
        IndexMetaUtils.addToDocument(INDEX_DOCUMENT_TYPE, "pid", document);
        IndexMetaUtils.addProfileToDocument(this.hwIcsLibDo, document);
        if (metaDo != null) {
            metaDo.getPropertyDoList().forEach(property -> IndexMetaUtils.addToDocument(property.getKey(), property.getValue(), document));
        }
        return document;
    }

    private void parseDocDynamicNode(String name, Attributes attributes) {
        String includeMetaValueIds = attributes.getValue("includemetavalueid");
        if (StringUtils.isBlank((CharSequence)includeMetaValueIds)) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Includemetavalueid is null.");
            return;
        }
        String[] bigTypeMetaValues = StringUtils.split((String)includeMetaValueIds, (String)";");
        List<MetaDo> metaDoList = this.pidMetaHandler.queryPidByMetaValue(bigTypeMetaValues, Integer.MAX_VALUE);
        Collections.reverse(metaDoList);
        for (MetaDo metaDo : metaDoList) {
            this.navPathStack.push(metaDo.getName());
            PidDo pidDo = new PidDo(metaDo.getId(), metaDo.getName(), this.createNavPath(), this.hwIcsLibDo.getDocId(), metaDo.getDocId());
            this.createPidDocument(pidDo, metaDo);
            this.addPidDo(pidDo);
            this.navPathStack.pop();
        }
        this.navPathStack.push("-1");
    }

    private String createNavPath() {
        return String.join((CharSequence)">", this.navPathStack);
    }
}

