/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.listener.impl;

import com.huawei.support.icscbb.commonsearch.index.bloom.HdxBloomFilterHandler;
import com.huawei.support.icscbb.commonsearch.index.parser.ParserFactory;
import com.huawei.support.icscbb.commonsearch.index.util.IndexFileUtils;
import com.huawei.support.icscbb.commonsearch.lucene.index.util.IndexUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.EventListener;
import com.huawei.support.icscbb.util.xml.context.ParserContext;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import com.huawei.support.icscbb.util.xml.sax.XmlSaxParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HdxMd5TopicHandler
implements EventListener {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxMd5TopicHandler.class);
    private static final String TOPIC_NODE_TEMPLATE = "<topic id=\"%s\" txt=\"%s\" url=\"%s\" libId=\"%s\" libVersion=\"%s\" topicPath=\"%s\" topicType=\"%s\"></topic>" + System.lineSeparator();
    private final StringBuilder md5TopicBuilder = new StringBuilder(1000);
    private final HdxBloomFilterHandler hdxBloomFilterHandler;
    private int topicCount;

    public HdxMd5TopicHandler(HdxBloomFilterHandler hdxBloomFilterHandler) {
        this.hdxBloomFilterHandler = hdxBloomFilterHandler;
    }

    public void invoke(String name, Attributes attributes, ParserContext parserContext) {
        if (!StringUtils.equals((CharSequence)name, (CharSequence)"item")) {
            return;
        }
        String topicId = attributes.getValue("id");
        String topicUrl = attributes.getValue("url");
        if (StringUtils.isBlank((CharSequence)topicUrl)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Topic[{0}] url is null.", new Object[]{topicId});
            return;
        }
        if (ParserFactory.getInstance().get("hdxtask", IndexUtils.getDocType(topicUrl)) == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Topic[{0}] url[{1}] is illegal.", new Object[]{topicId, topicUrl});
            return;
        }
        String resourceUrl = "resources/" + StringUtils.toRootLowerCase((String)topicUrl);
        if (this.hdxBloomFilterHandler != null && this.hdxBloomFilterHandler.naviContains(resourceUrl)) {
            return;
        }
        String topicNode = String.format(Locale.ROOT, TOPIC_NODE_TEMPLATE, StringEscapeUtils.escapeXml10((String)topicId), StringEscapeUtils.escapeXml10((String)""), StringEscapeUtils.escapeXml10((String)topicUrl), StringEscapeUtils.escapeXml10((String)parserContext.getStringValue("libId")), StringEscapeUtils.escapeXml10((String)parserContext.getStringValue("libVersion")), "", "1");
        this.md5TopicBuilder.append(topicNode);
        ++this.topicCount;
    }

    public void invokeAfter(String name, ParserContext parserContext) {
    }

    public void createNewTopic(ParserContext parserContext) {
        try (InputStream inputStream = ZipFilePool.getInputStream((String)parserContext.getStringValue("path"), (String)"resources/md5.xml");){
            if (inputStream == null) {
                return;
            }
            XmlSaxParser xmlSaxParser = new XmlSaxParser((EventListener)this, parserContext);
            SAXParserUtils.parseXml((InputStream)inputStream, (DefaultHandler)xmlSaxParser);
            IndexFileUtils.write(parserContext.getStringValue("savePath"), this.md5TopicBuilder.toString(), true);
        }
        catch (IOException | SAXException e) {
            this.topicCount = 0;
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Create md5 topic inputStream error", (Throwable)e);
        }
    }

    public StringBuilder getMd5TopicBuilder() {
        return this.md5TopicBuilder;
    }

    public HdxBloomFilterHandler getHdxBloomFilterHandler() {
        return this.hdxBloomFilterHandler;
    }

    public int getTopicCount() {
        return this.topicCount;
    }
}

