/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.listener.impl;

import com.huawei.support.icscbb.commonsearch.index.bloom.HdxBloomFilterHandler;
import com.huawei.support.icscbb.commonsearch.index.util.IndexFileUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.EventListener;
import com.huawei.support.icscbb.util.xml.context.ParserContext;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import com.huawei.support.icscbb.util.xml.sax.XmlSaxParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HdxNaviTopicHandler
implements EventListener {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxNaviTopicHandler.class);
    private static final String TOPIC_NODE_TEMPLATE = "<topic id=\"%s\" txt=\"%s\" url=\"%s\" libId=\"%s\" libVersion=\"%s\" topicPath=\"%s\" topicType=\"%s\"></topic>" + System.lineSeparator();
    private final HdxBloomFilterHandler hdxBloomFilterHandler;
    private final Map<Integer, String> naviMap = new HashMap<Integer, String>();
    private final StringBuilder naviTopicBuilder = new StringBuilder(2000);
    private int topicCount;
    private int level;

    public HdxNaviTopicHandler(HdxBloomFilterHandler bloomFilterHandler) {
        this.hdxBloomFilterHandler = bloomFilterHandler;
    }

    public void invoke(String name, Attributes attributes, ParserContext parserContext) {
        if (!StringUtils.equals((CharSequence)name, (CharSequence)"topic")) {
            return;
        }
        ++this.level;
        this.naviMap.put(this.level, attributes.getValue("txt"));
        String topicId = attributes.getValue("id");
        String url = attributes.getValue("url");
        if (StringUtils.isBlank((CharSequence)url)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Topic[{0}] url is null.", new Object[]{topicId});
            return;
        }
        String topicNode = String.format(Locale.ROOT, TOPIC_NODE_TEMPLATE, StringEscapeUtils.escapeXml10((String)topicId), StringEscapeUtils.escapeXml10((String)attributes.getValue("txt")), StringEscapeUtils.escapeXml10((String)url), StringEscapeUtils.escapeXml10((String)attributes.getValue("libId")), StringEscapeUtils.escapeXml10((String)attributes.getValue("libVersion")), StringEscapeUtils.escapeXml10((String)this.getNaviPath()), "0");
        this.naviTopicBuilder.append(topicNode);
        ++this.topicCount;
        this.hdxBloomFilterHandler.addToNaviBloomFilter("resources/" + StringUtils.toRootLowerCase((String)url));
    }

    public void invokeAfter(String name, ParserContext parserContext) {
        if ("topic".equals(name)) {
            --this.level;
        }
    }

    public void createNewTopic(ParserContext parserContext) {
        try (InputStream inputStream = ZipFilePool.getInputStream((String)parserContext.getStringValue("path"), (String)"resources/navi.xml");){
            if (inputStream == null) {
                return;
            }
            XmlSaxParser xmlSaxParser = new XmlSaxParser((EventListener)this, new ParserContext());
            SAXParserUtils.parseXml((InputStream)inputStream, (DefaultHandler)xmlSaxParser);
            IndexFileUtils.write(parserContext.getStringValue("savePath"), this.naviTopicBuilder.toString(), true);
        }
        catch (IOException | SAXException e) {
            this.topicCount = 0;
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Create navi topic inputStream error", (Throwable)e);
        }
    }

    private String getNaviPath() {
        StringBuilder topicPathBuilder = new StringBuilder();
        for (int i = 1; i <= this.level; ++i) {
            topicPathBuilder.append(this.naviMap.get(i));
            topicPathBuilder.append(">");
        }
        String topicPath = topicPathBuilder.toString();
        return StringUtils.isBlank((CharSequence)topicPath) ? topicPath : topicPath.substring(0, topicPath.length() - 1);
    }

    public HdxBloomFilterHandler getHdxBloomFilterHandler() {
        return this.hdxBloomFilterHandler;
    }

    public Map<Integer, String> getNaviMap() {
        return this.naviMap;
    }

    public StringBuilder getNaviTopicBuilder() {
        return this.naviTopicBuilder;
    }

    public int getTopicCount() {
        return this.topicCount;
    }

    public int getLevel() {
        return this.level;
    }
}

