/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.listener.impl;

import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsLibDo;
import com.huawei.support.icscbb.commonsearch.index.entity.MetaDo;
import com.huawei.support.icscbb.commonsearch.index.entity.PropertyDo;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.EventListener;
import com.huawei.support.icscbb.util.xml.context.ParserContext;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import com.huawei.support.icscbb.util.xml.sax.XmlSaxParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class MetaHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(MetaHandler.class);
    protected static final String META_KEY_START_PROPERTY = "propertyStart";
    protected static final String META_KEY_START_TAG = "tagStart";
    protected static final String META_KEY_START_RELATION = "relationStart";
    private static final String RELATION_TEMPLATE = "%s,%s,%s";
    private static final String XML_ATTR_PID = "pid_id";
    private static final String XML_ATTR_TOPIC_ID = "topic_id";
    private MetaDo currentMetaDo;
    private final Map<String, PropertyDo> propertyMap = new ConcurrentHashMap<String, PropertyDo>();
    private final BiConsumer<Attributes, ParserContext> pidOrTopicNodeConsumer = (attributes, parserContext) -> {
        String id = attributes.getValue("id");
        String docName = attributes.getValue("name");
        String url = attributes.getValue("url");
        String type = (String)StringUtils.defaultIfBlank((CharSequence)attributes.getValue("type"), (CharSequence)"pid");
        String docId = parserContext.getStringValue("docId");
        this.currentMetaDo = new MetaDo(id, docName, type, url, docId);
        this.add(this.getUniqueKey(docId, id), this.currentMetaDo);
    };
    private final BiConsumer<Attributes, ParserContext> propertyNodeConsumer = (attributes, parserContext) -> {
        PropertyDo property = this.getProperty((Attributes)attributes, "key", "value", parserContext.getStringValue(META_KEY_START_PROPERTY));
        this.currentMetaDo.getPropertyDoList().add(property);
    };
    private final BiConsumer<Attributes, ParserContext> tagNodeConsumer = (attributes, parserContext) -> this.currentMetaDo.getPropertyDoList().add(this.getProperty((Attributes)attributes, "metanameid", "valueid", parserContext.getStringValue(META_KEY_START_TAG)));
    private final BiConsumer<Attributes, ParserContext> relationNodeConsumer = (attributes, parserContext) -> this.currentMetaDo.getPropertyDoList().add(this.get(parserContext.getStringValue(META_KEY_START_RELATION), this.getRelation((Attributes)attributes)));
    private final BiConsumer<Attributes, ParserContext> contentNodeConsumer = (attributes, parserContext) -> this.currentMetaDo.setUrl(attributes.getValue("url"));
    private final Map<String, BiConsumer<Attributes, ParserContext>> functionMap = this.initFunction();

    private Map<String, BiConsumer<Attributes, ParserContext>> initFunction() {
        HashMap<String, BiConsumer<Attributes, ParserContext>> initFunctionMap = new HashMap<String, BiConsumer<Attributes, ParserContext>>();
        initFunctionMap.put("pid", this.pidOrTopicNodeConsumer);
        initFunctionMap.put("topic", this.pidOrTopicNodeConsumer);
        initFunctionMap.put("property", this.propertyNodeConsumer);
        initFunctionMap.put("tag", this.tagNodeConsumer);
        initFunctionMap.put("relation", this.relationNodeConsumer);
        initFunctionMap.put("content", this.contentNodeConsumer);
        return initFunctionMap;
    }

    public void init(HwIcsLibDo hwIcsLibDo) {
        this.propertyMap.clear();
        this.parse(hwIcsLibDo.getDocId(), hwIcsLibDo.getPath());
        ((List)Optional.ofNullable(hwIcsLibDo.getRelationLibInfos()).orElse(new ArrayList())).forEach(hwIcsRelationDo -> this.parse(hwIcsRelationDo.getDocId(), hwIcsRelationDo.getPath()));
    }

    protected PropertyDo get(String key, String value) {
        return this.propertyMap.computeIfAbsent(this.getUniqueKey(key, value), v -> new PropertyDo(key, value));
    }

    protected String getUniqueKey(String key, String value) {
        return key + "@" + value;
    }

    protected void parse(String path, String metaFilePath, EventListener eventListener, ParserContext parserContext) {
        try (InputStream inputStream = ZipFilePool.getInputStream((String)path, (String)metaFilePath);){
            if (inputStream == null) {
                return;
            }
            XmlSaxParser xmlSaxParser = new XmlSaxParser(eventListener, parserContext);
            SAXParserUtils.parseXml((InputStream)inputStream, (DefaultHandler)xmlSaxParser);
        }
        catch (IOException | SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Meta file parse error.", (Throwable)e);
        }
    }

    protected void parseAttributes(String name, Attributes attributes, ParserContext parserContext) {
        BiConsumer<Attributes, ParserContext> biConsumer = this.functionMap.get(name);
        if (biConsumer != null) {
            biConsumer.accept(attributes, parserContext);
        }
    }

    private PropertyDo getProperty(Attributes attributes, String keyName, String valueName, String keyStart) {
        String propertyName = keyStart + StringUtils.toRootLowerCase((String)attributes.getValue(keyName));
        return this.get(propertyName, attributes.getValue(valueName));
    }

    private String getRelation(Attributes attributes) {
        String pidId = attributes.getValue(XML_ATTR_PID);
        String name = (String)StringUtils.defaultIfBlank((CharSequence)attributes.getValue("name"), (CharSequence)"");
        if (StringUtils.isNotBlank((CharSequence)pidId)) {
            return String.format(Locale.ENGLISH, RELATION_TEMPLATE, XML_ATTR_PID, pidId, name);
        }
        String topicId = attributes.getValue(XML_ATTR_TOPIC_ID);
        if (StringUtils.isNotBlank((CharSequence)topicId)) {
            return String.format(Locale.ENGLISH, RELATION_TEMPLATE, XML_ATTR_TOPIC_ID, topicId, name);
        }
        String url = attributes.getValue("url");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{url, name})) {
            return "";
        }
        return String.format(Locale.ENGLISH, RELATION_TEMPLATE, "url", url, name);
    }

    public abstract MetaDo query(String var1, String var2);

    protected abstract void add(String var1, MetaDo var2);

    protected abstract void parse(String var1, String var2);
}

