/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.listener.impl;

import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsLibDo;
import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsRelationDo;
import com.huawei.support.icscbb.commonsearch.index.listener.impl.PidMetaHandler;
import com.huawei.support.icscbb.commonsearch.index.listener.impl.TopicMetaHandler;
import com.huawei.support.icscbb.commonsearch.index.util.IndexFileUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.pool.ZipFilePool;
import com.huawei.support.icscbb.util.xml.EventListener;
import com.huawei.support.icscbb.util.xml.context.ParserContext;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import com.huawei.support.icscbb.util.xml.sax.XmlSaxParser;
import com.huawei.wsf.core.HWEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PidHandler
implements EventListener {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(PidHandler.class);
    private static final int PID_REF_MAX_LEVEL = 5;
    private static final String PID_ROOT_PATH = "resources/infocenter_service/map/%s.xml";
    private static final String TOPIC_NODE_TEMPLATE = "<topic name=\"%s\" id=\"%s\" pid=\"%s\" docId=\"%s\" refDocId=\"%s\" parentDocIds=\"%s\" position=\"%s\" path=\"%s\" inc=\"%d\"></topic>" + System.lineSeparator();
    private final StringBuilder stringBuilder = new StringBuilder(1000);
    private PidMetaHandler pidMetaHandler;
    private TopicMetaHandler topicMetaHandler;
    private HwIcsLibDo hwIcsLibDo;
    private Stack<Integer> pathStack = new Stack();
    private Stack<String> topicPath = new Stack();
    private int currentIndex = 1;

    public void createNewPid(ParserContext parserContext) {
        String pIdRelativePath = String.format(PID_ROOT_PATH, parserContext.getStringValue("curPid"));
        try (InputStream inputStream = ZipFilePool.getInputStream((String)parserContext.getStringValue("path"), (String)pIdRelativePath);){
            if (inputStream == null) {
                return;
            }
            XmlSaxParser xmlSaxParser = new XmlSaxParser((EventListener)this, parserContext);
            SAXParserUtils.parseXml((InputStream)inputStream, (DefaultHandler)xmlSaxParser);
            IndexFileUtils.write(parserContext.getStringValue("savePath"), this.stringBuilder.toString(), true);
        }
        catch (IOException | SAXException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Create new pid error.", (Throwable)e);
        }
    }

    public void invoke(String name, Attributes attributes, ParserContext parserContext) {
        if (!"topic".equals(name)) {
            return;
        }
        String refPid = attributes.getValue("pid_id");
        if (StringUtils.isBlank((CharSequence)refPid)) {
            this.pathStack.push(this.currentIndex);
            String topicName = attributes.getValue("name");
            this.topicPath.push(HWEncoder.encodeForHTML((String)topicName));
            String topicId = attributes.getValue("id");
            String topicNode = String.format(Locale.ROOT, TOPIC_NODE_TEMPLATE, StringEscapeUtils.escapeXml10((String)topicName), topicId, parserContext.getStringValue("parentPid"), parserContext.getStringValue("docId"), this.getDocIdOfTopicById(parserContext.getStringValue("refDocId"), topicId), parserContext.getStringValue("parentDocIds"), StringUtils.join((Object[])this.pathStack.toArray(), (String)"."), StringEscapeUtils.escapeXml10((String)StringUtils.join((Object[])this.topicPath.toArray(), (String)">")), this.getIncFlag(parserContext, topicId));
            this.stringBuilder.append(topicNode);
            this.currentIndex = 1;
            return;
        }
        this.processRefPid(refPid, parserContext);
        this.pathStack.push(-1);
        this.topicPath.push("-1");
    }

    private int getIncFlag(ParserContext parserContext, String topicId) {
        if (this.topicMetaHandler.query(this.hwIcsLibDo.getDocId(), topicId) == null) {
            return 1;
        }
        return parserContext.getIntValue("inc");
    }

    private String getDocIdOfTopicById(String curDocId, String topicId) {
        if (this.topicMetaHandler.query(curDocId, topicId) != null) {
            return curDocId;
        }
        if (this.topicMetaHandler.query(this.hwIcsLibDo.getDocId(), topicId) != null) {
            return this.hwIcsLibDo.getDocId();
        }
        List relationLibInfos = Optional.ofNullable(this.hwIcsLibDo.getRelationLibInfos()).orElse(new ArrayList());
        for (HwIcsRelationDo relationLibInfo : relationLibInfos) {
            if (this.topicMetaHandler.query(relationLibInfo.getDocId(), topicId) == null) continue;
            return relationLibInfo.getDocId();
        }
        return "";
    }

    public void invokeAfter(String name, ParserContext parserContext) {
        if (!StringUtils.equals((CharSequence)"topic", (CharSequence)name)) {
            return;
        }
        this.currentIndex = this.pathStack.pop() + 1;
        this.topicPath.pop();
    }

    private void processRefPid(String refPid, ParserContext parserContext) {
        int layer = parserContext.getIntValue("layer");
        if (layer >= 5) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Ref level of [{0}] is more six. ", new Object[]{refPid});
            return;
        }
        if (this.processRefPid(refPid, parserContext, this.hwIcsLibDo.getDocId(), this.hwIcsLibDo.getPath(), parserContext.getIntValue("inc"))) {
            return;
        }
        List relationLibInfos = Optional.ofNullable(this.hwIcsLibDo.getRelationLibInfos()).orElse(new ArrayList());
        for (HwIcsRelationDo relationLibInfo : relationLibInfos) {
            int incFlag;
            int n = incFlag = relationLibInfo.isIncrement() ? 1 : parserContext.getIntValue("inc");
            if (!this.processRefPid(refPid, parserContext, relationLibInfo.getDocId(), relationLibInfo.getPath(), incFlag)) continue;
            break;
        }
    }

    private boolean processRefPid(String refPid, ParserContext parserContext, String docId, String path, int inc) {
        if (this.pidMetaHandler.query(docId, refPid) == null) {
            return false;
        }
        IndexFileUtils.write(parserContext.getStringValue("savePath"), this.stringBuilder.toString(), true);
        this.stringBuilder.setLength(0);
        PidHandler pidHandler = new PidHandler().setPidMetaHandler(this.pidMetaHandler).setTopicMetaHandler(this.topicMetaHandler).setHwIcsLibDo(this.hwIcsLibDo).setPathStack(this.pathStack).setTopicPath(this.topicPath).setCurrentIndex(this.currentIndex);
        pidHandler.createNewPid(new ParserContext().add("docId", (Object)parserContext.getStringValue("docId")).add("refDocId", (Object)docId).add("parentDocIds", (Object)(parserContext.getStringValue("parentDocIds") + "," + docId)).add("curPid", (Object)refPid).add("path", (Object)path).add("savePath", (Object)parserContext.getStringValue("savePath")).add("layer", (Object)(parserContext.getIntValue("layer") + 1)).add("parentPid", (Object)parserContext.getStringValue("parentPid")).add("inc", (Object)inc));
        return true;
    }

    public PidHandler setPidMetaHandler(PidMetaHandler pidMetaHandler) {
        this.pidMetaHandler = pidMetaHandler;
        return this;
    }

    public PidHandler setTopicMetaHandler(TopicMetaHandler topicMetaHandler) {
        this.topicMetaHandler = topicMetaHandler;
        return this;
    }

    public PidHandler setHwIcsLibDo(HwIcsLibDo hwIcsLibDo) {
        this.hwIcsLibDo = hwIcsLibDo;
        return this;
    }

    public PidHandler setPathStack(Stack<Integer> pathStack) {
        this.pathStack = pathStack;
        return this;
    }

    public PidHandler setTopicPath(Stack<String> topicPath) {
        this.topicPath = topicPath;
        return this;
    }

    public PidHandler setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
        return this;
    }
}

