/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.listener.impl;

import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsLibDo;
import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsRelationDo;
import com.huawei.support.icscbb.commonsearch.index.entity.MetaDo;
import com.huawei.support.icscbb.commonsearch.index.entity.MetaExtDo;
import com.huawei.support.icscbb.commonsearch.index.entity.PropertyDo;
import com.huawei.support.icscbb.commonsearch.index.listener.impl.MetaHandler;
import com.huawei.support.icscbb.util.xml.EventListener;
import com.huawei.support.icscbb.util.xml.context.ParserContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;

public class PidMetaHandler
extends MetaHandler
implements EventListener {
    private static final String PID_META_PATH = "resources/infocenter_service/metadata/pid_meta.xml";
    private final Map<String, MetaDo> metaMap = new HashMap<String, MetaDo>();

    @Override
    public MetaDo query(String docId, String id) {
        return this.metaMap.get(this.getUniqueKey(docId, id));
    }

    @Override
    protected void parse(String docId, String path) {
        this.parse(path, PID_META_PATH, this, new ParserContext().add("docId", (Object)docId).add("propertyStart", (Object)"pp_").add("tagStart", (Object)"pt_").add("relationStart", (Object)"pr_relation"));
    }

    public List<MetaDo> queryPidByMetaValue(String[] bigTypeMetaValues, int limit) {
        return this.metaMap.values().stream().filter(metaDo -> this.isFullMatch(bigTypeMetaValues, metaDo.getPropertyDoList())).limit(limit).collect(Collectors.toList());
    }

    private boolean isFullMatch(String[] bigTypeMetaValues, List<PropertyDo> propertyDoList) {
        for (String metaValueIds : bigTypeMetaValues) {
            if (!propertyDoList.stream().noneMatch(propertyDo -> StringUtils.containsIgnoreCase((CharSequence)metaValueIds, (CharSequence)propertyDo.getValue()))) continue;
            return false;
        }
        return true;
    }

    public Optional<MetaExtDo> queryExtMetaDo(HwIcsLibDo hwIcsLibDo, String id) {
        Optional<MetaExtDo> metaExtDo = this.getMetaExtDoFromMainLib(hwIcsLibDo, id);
        if (metaExtDo.isPresent()) {
            return metaExtDo;
        }
        return this.getMetaExtDoFromRelationLib(hwIcsLibDo, id);
    }

    private Optional<MetaExtDo> getMetaExtDoFromRelationLib(HwIcsLibDo hwIcsLibDo, String id) {
        List relationLibInfos = Optional.ofNullable(hwIcsLibDo).map(HwIcsLibDo::getRelationLibInfos).orElse(new ArrayList());
        for (HwIcsRelationDo relationLibInfo : relationLibInfos) {
            MetaDo metaDo = this.query(relationLibInfo.getDocId(), id);
            if (metaDo == null) continue;
            return Optional.of(new MetaExtDo(metaDo, relationLibInfo.getDocId(), relationLibInfo.getPath()));
        }
        return Optional.empty();
    }

    private Optional<MetaExtDo> getMetaExtDoFromMainLib(HwIcsLibDo hwIcsLibDo, String id) {
        return Optional.ofNullable(hwIcsLibDo).map(icsLibDo -> this.query(icsLibDo.getDocId(), id)).map(metaDo -> new MetaExtDo((MetaDo)metaDo, hwIcsLibDo.getDocId(), hwIcsLibDo.getPath()));
    }

    @Override
    protected void add(String key, MetaDo metaDo) {
        this.metaMap.put(key, metaDo);
    }

    public void invoke(String name, Attributes attributes, ParserContext parserContext) {
        this.parseAttributes(name, attributes, parserContext);
    }

    public void invokeAfter(String name, ParserContext parserContext) {
    }
}

