/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.manager;

import com.huawei.support.icscbb.commonsearch.index.entity.HdxLibDo;
import com.huawei.support.icscbb.commonsearch.index.entity.LibBaseDo;
import com.huawei.support.icscbb.commonsearch.index.manager.IndexManagerHandler;
import com.huawei.support.icscbb.commonsearch.lucene.index.exception.IndexException;
import com.huawei.support.icscbb.commonsearch.lucene.index.service.IndexManager;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.File;

public class HdxIndexManagerHandler
extends IndexManagerHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxIndexManagerHandler.class);

    @Override
    public void init(LibBaseDo libBaseDo, int threadNum) {
        HdxLibDo hdxLibDo = (HdxLibDo)libBaseDo;
        for (int i = 0; i < threadNum; ++i) {
            this.createHdxIndexManager(hdxLibDo, File.separator + "index" + i);
        }
    }

    private void createHdxIndexManager(HdxLibDo hdxLibDo, String subIndexDir) {
        String indexDir = hdxLibDo.getIndexDir() + subIndexDir;
        try {
            IndexManager hdxIndexManager = new IndexManager(hdxLibDo.getIndexLang(), indexDir, false);
            this.add(hdxLibDo.getDocId(), hdxIndexManager);
        }
        catch (IndexException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "hdx init index manager error", (Throwable)e);
        }
    }
}

