/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.manager;

import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsLibDo;
import com.huawei.support.icscbb.commonsearch.index.entity.LibBaseDo;
import com.huawei.support.icscbb.commonsearch.index.manager.IndexManagerHandler;
import com.huawei.support.icscbb.commonsearch.index.util.IndexDirHelper;
import com.huawei.support.icscbb.commonsearch.lucene.index.exception.IndexException;
import com.huawei.support.icscbb.commonsearch.lucene.index.service.IndexManager;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class IcsIndexManagerHandler
extends IndexManagerHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsIndexManagerHandler.class);

    @Override
    public void init(LibBaseDo libBaseDo, int threadNum) {
        HwIcsLibDo hwIcsLibDo = (HwIcsLibDo)libBaseDo;
        for (int i = 0; i < threadNum; ++i) {
            this.createIndexManager(hwIcsLibDo, hwIcsLibDo.getDocId(), File.separator + "index" + i);
        }
        ((List)Optional.ofNullable(hwIcsLibDo.getRelationLibInfos()).orElse(new ArrayList())).forEach(hwIcsRelationDo -> this.createIndexManager(hwIcsLibDo, hwIcsRelationDo.getDocId(), ""));
    }

    private void createIndexManager(HwIcsLibDo hwIcsLibDo, String refDocId, String subIndexDir) {
        String indexDir = hwIcsLibDo.getIndexDir() + IndexDirHelper.getSubIndexDir(refDocId, hwIcsLibDo.getSoftVersion(), hwIcsLibDo.getTaskType()) + subIndexDir;
        try {
            this.add(refDocId, new IndexManager(hwIcsLibDo.getIndexLang(), indexDir, false));
        }
        catch (IndexException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "init index manager error.", (Throwable)e);
        }
    }
}

