/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.manager;

import com.huawei.support.icscbb.commonsearch.index.entity.LibBaseDo;
import com.huawei.support.icscbb.commonsearch.lucene.index.exception.IndexException;
import com.huawei.support.icscbb.commonsearch.lucene.index.service.IndexManager;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;

public abstract class IndexManagerHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IndexManagerHandler.class);
    protected final Map<String, BlockingQueue<IndexManager>> indexManagerMap = new ConcurrentHashMap<String, BlockingQueue<IndexManager>>();

    public IndexManager get(String docId) throws InterruptedException {
        if (!this.indexManagerMap.containsKey(docId)) {
            return null;
        }
        return this.indexManagerMap.get(docId).take();
    }

    public void add(String docId, IndexManager indexManager) {
        if (indexManager == null) {
            return;
        }
        this.indexManagerMap.computeIfAbsent(docId, key -> new LinkedBlockingDeque()).add(indexManager);
    }

    public void close() {
        this.indexManagerMap.values().forEach(indexManagers -> indexManagers.forEach(IndexManager::close));
    }

    public void commit() {
        this.indexManagerMap.values().forEach(indexManagers -> indexManagers.forEach(indexManager -> {
            try {
                indexManager.commit();
            }
            catch (IndexException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Index commit fail.", (Throwable)e);
            }
        }));
    }

    public abstract void init(LibBaseDo var1, int var2);
}

