/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.parser;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.huawei.support.icscbb.commonsearch.index.parser.DocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.html.HdxHtmlDocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.html.IcsHtmlDocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.msexcel.ExcelDocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.msoffice.OfficeDocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.msppt.PptDocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.msppt.PptxDocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.msword.DocDocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.msword.DocxDocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.pdf.PdfDocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.txt.TxtDocumentParser;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ParserFactory {
    private static final ParserFactory PARSER_FACTORY = new ParserFactory();
    private static final Map<String, DocumentParser> PARSER_MAP = new HashMap<String, DocumentParser>();

    public static ParserFactory getInstance() {
        return PARSER_FACTORY;
    }

    private ParserFactory() {
    }

    public DocumentParser get(String taskType, String docType) {
        String actualDocType = StringUtils.toRootLowerCase((String)docType);
        if (StringUtils.equalsAny((CharSequence)actualDocType, (CharSequence[])new CharSequence[]{".html", ".htm"})) {
            actualDocType = taskType + actualDocType;
        }
        return PARSER_MAP.get(actualDocType);
    }

    static {
        PARSER_MAP.put("hwicstask.html", new IcsHtmlDocumentParser());
        PARSER_MAP.put("hwicstask.htm", new IcsHtmlDocumentParser());
        PARSER_MAP.put("hdxtask.html", new HdxHtmlDocumentParser());
        PARSER_MAP.put("hdxtask.htm", new HdxHtmlDocumentParser());
        PARSER_MAP.put(".txt", new TxtDocumentParser());
        PARSER_MAP.put(".doc", new DocDocumentParser());
        PARSER_MAP.put(".docm", new OfficeDocumentParser());
        PARSER_MAP.put(".docx", new DocxDocumentParser());
        PARSER_MAP.put(".xls", new ExcelDocumentParser(ExcelTypeEnum.XLS));
        PARSER_MAP.put(".xlsm", new OfficeDocumentParser());
        PARSER_MAP.put(".xlsx", new ExcelDocumentParser(ExcelTypeEnum.XLSX));
        PARSER_MAP.put(".ppt", new PptDocumentParser());
        PARSER_MAP.put(".pptm", new OfficeDocumentParser());
        PARSER_MAP.put(".pptx", new PptxDocumentParser());
        PARSER_MAP.put(".pdf", new PdfDocumentParser());
    }
}

