/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.parser.html;

import com.huawei.support.icscbb.commonsearch.index.parser.DocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.html.AbstractHtmlDocumentParser;
import com.huawei.support.icscbb.commonsearch.lucene.index.util.IndexUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HdxHtmlDocumentParser
extends AbstractHtmlDocumentParser
implements DocumentParser {
    private static final String TAG_ATTR_NAME_CONTENT = "content";
    private static final String TAG_ATTR_NAME_NAME = "name";

    @Override
    public List<Field> extract(String topicUrl, String path, String title) {
        return this.extractField(topicUrl, path, title);
    }

    @Override
    protected Field getTitleField(String title, String topicUrl, Document document) {
        String hdxTitle = (String)StringUtils.defaultIfBlank((CharSequence)document.title(), (CharSequence)IndexUtils.getFileNameNotSuffix(topicUrl));
        return IndexUtils.getField("t_title", hdxTitle, Field.Store.YES, TextField.class.getSimpleName());
    }

    @Override
    protected void addTopicMeta(Document document, List<Field> textFields) {
        super.addTopicMeta(document, textFields);
        this.handleSummary((Element)document, textFields);
    }

    private void handleSummary(Element element, List<Field> textFields) {
        Elements summaryElements = element.getElementsByAttributeValue(TAG_ATTR_NAME_NAME, "description");
        String summary = "";
        if (CollectionUtils.isNotEmpty((Collection)summaryElements)) {
            summary = ((Element)summaryElements.get(0)).attr(TAG_ATTR_NAME_CONTENT);
        }
        textFields.add(IndexUtils.getField("summary", summary, Field.Store.YES, TextField.class.getSimpleName()));
    }
}

