/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.parser.msexcel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.huawei.support.icscbb.commonsearch.index.parser.DocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.msexcel.ExcelListener;
import com.huawei.support.icscbb.commonsearch.index.parser.util.DocumentParserUtils;
import com.huawei.support.icscbb.commonsearch.lucene.index.util.IndexUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.poi.openxml4j.util.ZipSecureFile;

public class ExcelDocumentParser
implements DocumentParser {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(ExcelDocumentParser.class);
    private static final int SHEET_MAX_NUM = 5;
    private final ExcelTypeEnum excelTypeEnum;

    public ExcelDocumentParser() {
        this.excelTypeEnum = ExcelTypeEnum.XLS;
    }

    public ExcelDocumentParser(ExcelTypeEnum excelTypeEnum) {
        this.excelTypeEnum = excelTypeEnum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Field> extract(String topicUrl, String path, String title) {
        try (InputStream inputStream = DocumentParserUtils.getTopicInputStream(path, topicUrl);){
            List<Field> list = this.getField(inputStream, topicUrl, title);
            return list;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]Error occurred while parsing excel.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<Field> getField(InputStream inputStream, String topicUrl, String title) {
        ArrayList<Field> textFields = new ArrayList<Field>();
        if (inputStream == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]topic not exist:{0}.", new Object[]{topicUrl});
            return textFields;
        }
        try (BufferedInputStream bis = new BufferedInputStream(inputStream);){
            textFields.add(this.getTitleField(topicUrl, title));
            textFields.add(this.getContentField(bis));
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]Error occurred while parsing excel.", (Throwable)e);
        }
        return textFields;
    }

    private Field getTitleField(String topicUrl, String title) {
        String txtTitle = (String)StringUtils.defaultIfBlank((CharSequence)title, (CharSequence)IndexUtils.getFileNameNotSuffix(topicUrl));
        return IndexUtils.getField("t_title", txtTitle, Field.Store.YES, TextField.class.getSimpleName());
    }

    private Field getContentField(InputStream excelIs) {
        ExcelListener excelListener = new ExcelListener();
        ExcelReader excelReader = EasyExcel.read((InputStream)excelIs, (ReadListener)excelListener).excelType(this.excelTypeEnum).build();
        int num = excelReader.excelExecutor().sheetList().size();
        num = Math.min(num, 5);
        for (int index = 0; index < num; ++index) {
            ReadSheet readSheet = EasyExcel.readSheet((Integer)index).build();
            excelReader.read(new ReadSheet[]{readSheet});
        }
        excelReader.finish();
        String excelContent = String.join((CharSequence)" ", excelListener.getContentList());
        String excelContents = IndexUtils.replaceSpecialCharacter(excelContent);
        return IndexUtils.getField("t_content", excelContents, Field.Store.YES, TextField.class.getSimpleName());
    }

    static {
        ZipSecureFile.setMinInflateRatio((double)0.0);
    }
}

