/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.parser.msoffice;

import com.huawei.support.icscbb.commonsearch.index.parser.DocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.util.DocumentParserUtils;
import com.huawei.support.icscbb.commonsearch.lucene.index.util.IndexUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.extractor.POITextExtractor;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;

public class OfficeDocumentParser
implements DocumentParser {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(OfficeDocumentParser.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Field> extract(String topicUrl, String path, String title) {
        try (InputStream inputStream = DocumentParserUtils.getTopicInputStream(path, topicUrl);){
            List<Field> list = this.getField(inputStream, topicUrl, title);
            return list;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]Error occurred while parsing office.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<Field> getField(InputStream inputStream, String topicUrl, String title) {
        ArrayList<Field> officeFields = new ArrayList<Field>();
        if (inputStream == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]topic not exist:{0}.", new Object[]{topicUrl});
            return officeFields;
        }
        try (POITextExtractor poiTextExtractor = ExtractorFactory.createExtractor((InputStream)inputStream);){
            officeFields.add(this.getTitleField(topicUrl, title));
            officeFields.add(this.getContentField(poiTextExtractor));
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]Error occurred while parsing office.", (Throwable)e);
        }
        return officeFields;
    }

    private Field getTitleField(String topicUrl, String title) {
        String officeTitle = (String)StringUtils.defaultIfBlank((CharSequence)title, (CharSequence)IndexUtils.getFileNameNotSuffix(topicUrl));
        return IndexUtils.getField("t_title", officeTitle, Field.Store.YES, TextField.class.getSimpleName());
    }

    private Field getContentField(POITextExtractor poiTextExtractor) {
        String bodyText;
        String officeContent = "";
        if (poiTextExtractor instanceof XWPFWordExtractor) {
            this.handlePoiExtractor((XWPFWordExtractor)poiTextExtractor);
        }
        if (StringUtils.isNotBlank((CharSequence)(bodyText = poiTextExtractor.getText()))) {
            officeContent = IndexUtils.replaceSpecialAndBlank(officeContent);
        }
        return IndexUtils.getField("t_content", officeContent, Field.Store.YES, TextField.class.getSimpleName());
    }

    private void handlePoiExtractor(XWPFWordExtractor poiTextExtractor) {
        XWPFDocument xwpfDocument = poiTextExtractor.getDocument();
        List xwpfHeaders = xwpfDocument.getHeaderList();
        xwpfHeaders.forEach(XWPFHeaderFooter::clearHeaderFooter);
        List xwpfFooters = xwpfDocument.getFooterList();
        xwpfFooters.forEach(XWPFHeaderFooter::clearHeaderFooter);
    }
}

