/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.parser.msppt;

import com.huawei.support.icscbb.commonsearch.index.parser.DocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.util.DocumentParserUtils;
import com.huawei.support.icscbb.commonsearch.lucene.index.util.IndexUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.sl.extractor.SlideShowExtractor;
import org.apache.poi.sl.usermodel.SlideShow;

public class PptDocumentParser
implements DocumentParser {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(PptDocumentParser.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Field> extract(String topicUrl, String path, String title) {
        try (InputStream inputStream = DocumentParserUtils.getTopicInputStream(path, topicUrl);){
            List<Field> list = this.getField(inputStream, topicUrl, title);
            return list;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]Error occurred while parsing ppt.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<Field> getField(InputStream inputStream, String topicUrl, String title) {
        ArrayList<Field> pptFields = new ArrayList<Field>();
        if (inputStream == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]topic not exist:{0}.", new Object[]{topicUrl});
            return pptFields;
        }
        try (HSLFSlideShow slideshow = new HSLFSlideShow(inputStream);
             SlideShowExtractor slideShowExtractor = new SlideShowExtractor((SlideShow)slideshow);){
            slideShowExtractor.setCommentsByDefault(true);
            slideShowExtractor.setMasterByDefault(true);
            slideShowExtractor.setNotesByDefault(true);
            String pptTitle = (String)StringUtils.defaultIfBlank((CharSequence)title, (CharSequence)IndexUtils.getFileNameNotSuffix(topicUrl));
            pptFields.add(IndexUtils.getField("t_title", pptTitle, Field.Store.YES, TextField.class.getSimpleName()));
            String pptContents = IndexUtils.replaceSpecialCharacter(slideShowExtractor.getText());
            pptFields.add(IndexUtils.getField("t_content", pptContents, Field.Store.YES, TextField.class.getSimpleName()));
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]Error occurred while parsing ppt.", (Throwable)e);
        }
        return pptFields;
    }
}

