/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.parser.msppt;

import com.huawei.support.icscbb.commonsearch.index.parser.DocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.util.DocumentParserUtils;
import com.huawei.support.icscbb.commonsearch.lucene.index.util.IndexUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.poi.sl.extractor.SlideShowExtractor;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.xslf.usermodel.XMLSlideShow;

public class PptxDocumentParser
implements DocumentParser {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(PptxDocumentParser.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Field> extract(String topicUrl, String path, String title) {
        try (InputStream inputStream = DocumentParserUtils.getTopicInputStream(path, topicUrl);){
            List<Field> list = this.getField(inputStream, topicUrl, title);
            return list;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]Error occurred while parsing pptx.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<Field> getField(InputStream inputStream, String topicUrl, String title) {
        ArrayList<Field> textFields = new ArrayList<Field>();
        if (inputStream == null) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]topic not exist:{0}.", new Object[]{topicUrl});
            return textFields;
        }
        try (XMLSlideShow slideshow = new XMLSlideShow(inputStream);
             SlideShowExtractor slideShowExtractor = new SlideShowExtractor((SlideShow)slideshow);){
            slideShowExtractor.setCommentsByDefault(true);
            slideShowExtractor.setMasterByDefault(true);
            slideShowExtractor.setNotesByDefault(true);
            String pptxTitle = (String)StringUtils.defaultIfBlank((CharSequence)title, (CharSequence)IndexUtils.getFileNameNotSuffix(topicUrl));
            textFields.add(IndexUtils.getField("t_title", pptxTitle, Field.Store.YES, TextField.class.getSimpleName()));
            String pptxContents = IndexUtils.replaceSpecialCharacter(slideShowExtractor.getText());
            textFields.add(IndexUtils.getField("t_content", pptxContents, Field.Store.YES, TextField.class.getSimpleName()));
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]Error occurred while parsing pptx.", (Throwable)e);
        }
        return textFields;
    }
}

