/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.parser.msword;

import com.huawei.support.icscbb.commonsearch.index.parser.DocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.util.DocumentParserUtils;
import com.huawei.support.icscbb.commonsearch.lucene.index.util.IndexUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;

public class DocxDocumentParser
implements DocumentParser {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(DocxDocumentParser.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Field> extract(String topicUrl, String path, String title) {
        ArrayList<Field> textFields = new ArrayList<Field>();
        try (InputStream inputStream = DocumentParserUtils.getTopicInputStream(path, topicUrl);
             XWPFWordExtractor extractor = this.getXwpfDocument(inputStream);){
            if (extractor == null) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]topic not exist:{0}.", new Object[]{topicUrl});
                ArrayList<Field> arrayList = textFields;
                return arrayList;
            }
            String docxTitle = (String)StringUtils.defaultIfBlank((CharSequence)title, (CharSequence)IndexUtils.getFileNameNotSuffix(topicUrl));
            textFields.add(IndexUtils.getField("t_title", docxTitle, Field.Store.YES, TextField.class.getSimpleName()));
            String docxContent = StringUtils.isBlank((CharSequence)extractor.getText()) ? "" : IndexUtils.replaceSpecialCharacter(extractor.getText());
            textFields.add(IndexUtils.getField("t_content", docxContent, Field.Store.YES, TextField.class.getSimpleName()));
            return textFields;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]Error occurred while parsing docx.", (Throwable)e);
        }
        return textFields;
    }

    private XWPFWordExtractor getXwpfDocument(InputStream docxInputStream) throws IOException {
        if (docxInputStream == null) {
            return null;
        }
        try (XWPFDocument xwpfDocument = new XWPFDocument(docxInputStream);){
            List xwpfHeaders = xwpfDocument.getHeaderList();
            xwpfHeaders.forEach(XWPFHeaderFooter::clearHeaderFooter);
            List xwpfFooters = xwpfDocument.getFooterList();
            xwpfFooters.forEach(XWPFHeaderFooter::clearHeaderFooter);
            XWPFWordExtractor xWPFWordExtractor = new XWPFWordExtractor(xwpfDocument);
            return xWPFWordExtractor;
        }
    }
}

