/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.parser.txt;

import com.huawei.support.icscbb.commonsearch.index.parser.DocumentParser;
import com.huawei.support.icscbb.commonsearch.index.parser.util.DocumentParserUtils;
import com.huawei.support.icscbb.commonsearch.lucene.index.util.IndexUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.file.IcsFileUtils;
import com.ibm.icu.text.CharsetMatch;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;

public class TxtDocumentParser
implements DocumentParser {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(TxtDocumentParser.class);

    @Override
    public List<Field> extract(String topicUrl, String path, String title) {
        ArrayList<Field> textFields = new ArrayList<Field>();
        try (InputStream inputStream = DocumentParserUtils.getTopicInputStream(path, topicUrl);){
            CharsetMatch charset = IcsFileUtils.getCharsetMatch((InputStream)inputStream);
            String txtContents = IndexUtils.replaceSpecialCharacter(charset.getString());
            textFields.add(IndexUtils.getField("t_content", txtContents, Field.Store.YES, TextField.class.getSimpleName()));
            String txtTitle = (String)StringUtils.defaultIfBlank((CharSequence)title, (CharSequence)IndexUtils.getFileNameNotSuffix(topicUrl));
            textFields.add(IndexUtils.getField("t_title", txtTitle, Field.Store.YES, TextField.class.getSimpleName()));
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]Error occurred while parsing txt.", (Throwable)e);
        }
        return textFields;
    }
}

