/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.query;

import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsQueryDto;
import com.huawei.support.icscbb.commonsearch.lucene.analyzer.SimpleAnalyzerFactory;
import com.huawei.support.icscbb.commonsearch.lucene.search.dto.ParamBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.query.QueryBase;
import com.huawei.support.icscbb.commonsearch.lucene.search.util.PhraseQueryUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class HwIcsMetaQuery
implements QueryBase {
    private static final CommonLogger LOG = CommonLoggerFactory.getLogger(HwIcsMetaQuery.class);

    @Override
    public Query create(ParamBase paramBase) {
        Query query = null;
        try {
            HwIcsQueryDto queryDto = (HwIcsQueryDto)paramBase;
            Analyzer analyzer = SimpleAnalyzerFactory.getInstance().getAnalyzer(queryDto.getLang());
            BooleanQuery baseQuery = PhraseQueryUtils.getCommonQuery(queryDto, queryDto.getSearchText());
            Query extraQuery = PhraseQueryUtils.buildExtraQuery(queryDto.getExtraConditions(), analyzer, paramBase.getType());
            query = PhraseQueryUtils.attachExtraQuery((Query)baseQuery, extraQuery);
        }
        catch (ParseException e) {
            CodeCCUtils.INSTANCE.errorLog(LOG, "Create query fail.", (Throwable)e);
        }
        return query;
    }
}

