/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.service;

import com.huawei.support.icscbb.commonsearch.index.entity.LibBaseDo;
import com.huawei.support.icscbb.commonsearch.index.entity.TripleInfo;
import com.huawei.support.icscbb.commonsearch.index.service.TripleHandler;
import com.huawei.support.icscbb.commonsearch.index.template.DefaultIndexTemplate;
import com.huawei.support.icscbb.commonsearch.index.template.HdxIndexTemplate;
import com.huawei.support.icscbb.commonsearch.index.template.IcsIndexTemplate;
import com.huawei.support.icscbb.commonsearch.lucene.index.dto.FieldInfoDto;
import com.huawei.support.icscbb.commonsearch.lucene.index.exception.IndexException;
import com.huawei.support.icscbb.commonsearch.lucene.index.service.IndexManager;
import com.huawei.support.icscbb.commonsearch.lucene.search.util.SearchUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.File;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class IndexFacade {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IndexFacade.class);

    private IndexFacade() {
    }

    public static boolean delete(String indexDir) {
        return FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{indexDir}));
    }

    public static boolean create(LibBaseDo libBase, String taskType) {
        Optional<DefaultIndexTemplate> indexHandler = IndexFacade.getIndexHandler(taskType);
        if (indexHandler.isPresent()) {
            return indexHandler.get().process(libBase);
        }
        return false;
    }

    private static Optional<DefaultIndexTemplate> getIndexHandler(String taskType) {
        if (StringUtils.equals((CharSequence)taskType, (CharSequence)"hwicstask")) {
            return Optional.of(new IcsIndexTemplate());
        }
        if (StringUtils.equals((CharSequence)taskType, (CharSequence)"hdxtask")) {
            return Optional.of(new HdxIndexTemplate());
        }
        return Optional.empty();
    }

    public static boolean createTripleIndex(TripleInfo tripleInfo) {
        TripleHandler tripleHandler = new TripleHandler();
        return tripleHandler.process(tripleInfo);
    }

    public static long deleteIndex(FieldInfoDto fieldInfo, String indexRootDir, String lang) {
        Set<String> indexDirs = SearchUtils.getIndexDirs(indexRootDir, Runtime.getRuntime().availableProcessors());
        long count = 0L;
        for (String indexDir : indexDirs) {
            try {
                IndexManager icsIndexManager = new IndexManager(lang, indexDir, false);
                Throwable throwable = null;
                try {
                    count += icsIndexManager.deleteIndex(fieldInfo, lang);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (icsIndexManager == null) continue;
                    if (throwable != null) {
                        try {
                            icsIndexManager.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    icsIndexManager.close();
                }
            }
            catch (IndexException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Delete index error.", (Throwable)e);
            }
        }
        return count;
    }
}

