/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.service;

import com.huawei.support.icscbb.commonsearch.index.entity.TripleInfo;
import com.huawei.support.icscbb.commonsearch.lucene.index.dto.IndexTripleInfoDto;
import com.huawei.support.icscbb.commonsearch.lucene.index.exception.IndexException;
import com.huawei.support.icscbb.commonsearch.lucene.index.service.IndexManager;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class TripleHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(TripleHandler.class);
    private static final String FILE_SEPERATER_SPLIT = "/";
    private static final String TRIPLEENTITY = "entity";
    private static final int FILELIMIT = 200;
    private static final long MAX_FILE_COUNT = 500L;

    public boolean process(TripleInfo tripleInfo) {
        if (tripleInfo == null) {
            return false;
        }
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "[index]start create index:{0}", new Object[]{tripleInfo.getDocId()});
        if (StringUtils.isBlank((CharSequence)tripleInfo.getIndexDir())) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "[index]index root dir is null, from ics lite storage adapter");
            return false;
        }
        boolean isSuccess = true;
        List<IndexTripleInfoDto> indexTripleInfoDtos = this.getParsePath(tripleInfo);
        try (IndexManager indexManager = new IndexManager(tripleInfo.getLanguage(), tripleInfo.getIndexDir(), false);){
            for (IndexTripleInfoDto indexTripleInfoDto : indexTripleInfoDtos) {
                indexManager.addTripleIndex(indexTripleInfoDto);
            }
        }
        catch (IndexException | IOException e) {
            isSuccess = false;
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "get indexManager  error", (Throwable)e);
        }
        return isSuccess;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<IndexTripleInfoDto> getParsePath(TripleInfo tripleInfos) {
        if (tripleInfos == null) {
            return Collections.emptyList();
        }
        try (ZipFile zipFile = new ZipFile(FileUtils.getFile((String[])new String[]{tripleInfos.getPath()}), "GBK");){
            List<IndexTripleInfoDto> list = this.change2IndexTripleInfoDto(this.getFileNames(zipFile), tripleInfos);
            return list;
        }
        catch (IOException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "An IO error occurred", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<String> getFileNames(ZipFile zipFile) {
        List<String> fileNames = this.getkgEntiy(zipFile);
        if (CollectionUtils.isEmpty(fileNames)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "no csv file");
            return Collections.emptyList();
        }
        if (fileNames.size() > 200) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "file is out of limit");
            return Collections.emptyList();
        }
        return fileNames;
    }

    private List<String> getkgEntiy(ZipFile zipFile) {
        ArrayList<String> fileNames = new ArrayList<String>();
        Enumeration entries = zipFile.getEntries();
        int fileCount = 0;
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
            String fileName = this.getFileName(entry);
            if (StringUtils.isBlank((CharSequence)fileName)) continue;
            fileNames.add(fileName);
            if ((long)(++fileCount) <= 500L) continue;
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "zip file match MAX_FILE_COUNT!");
            return fileNames;
        }
        return fileNames;
    }

    private String getFileName(ZipArchiveEntry entry) {
        if (entry.isDirectory()) {
            return "";
        }
        String name = entry.getName();
        if (StringUtils.indexOf((CharSequence)name, (CharSequence)FILE_SEPERATER_SPLIT) < 0) {
            return "";
        }
        String beforeLast = StringUtils.substring((String)name, (int)0, (int)StringUtils.lastIndexOf((CharSequence)name, (CharSequence)FILE_SEPERATER_SPLIT));
        String entity = StringUtils.substring((String)beforeLast, (int)(StringUtils.lastIndexOf((CharSequence)beforeLast, (CharSequence)FILE_SEPERATER_SPLIT) + 1));
        String fileName = "";
        if (StringUtils.equals((CharSequence)entity, (CharSequence)TRIPLEENTITY)) {
            fileName = StringUtils.substring((String)name, (int)(StringUtils.lastIndexOf((CharSequence)name, (CharSequence)FILE_SEPERATER_SPLIT) + 1));
        }
        return fileName;
    }

    private List<IndexTripleInfoDto> change2IndexTripleInfoDto(List<String> fileNames, TripleInfo tripleInfodata) {
        if (CollectionUtils.isEmpty(fileNames)) {
            return Collections.emptyList();
        }
        return fileNames.stream().map(fileName -> new IndexTripleInfoDto(tripleInfodata.getPath(), (String)fileName)).collect(Collectors.toList());
    }
}

