/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.template;

import com.huawei.support.icscbb.commonsearch.index.config.IndexConfigHandler;
import com.huawei.support.icscbb.commonsearch.index.entity.LibBaseDo;
import com.huawei.support.icscbb.commonsearch.index.template.help.IndexInfoManagerHandler;
import com.huawei.support.icscbb.commonsearch.index.template.help.SemaphoreHandler;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.thread.NamedThreadFactory;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;

public abstract class DefaultIndexTemplate {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(DefaultIndexTemplate.class);
    private static final long THREAD_KEEP_ALIVE_SECONDS = 600L;
    private static final int THREAD_POOL_QUEUE_SIZE = 20;
    protected IndexInfoManagerHandler indexInfoManagerHandler;
    protected ThreadPoolExecutor threadPool;
    protected SemaphoreHandler semaphoreHandler;

    public final boolean process(LibBaseDo libBaseDo) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Index create start.");
        if (libBaseDo == null) {
            CodeCCUtils.INSTANCE.warnLog(LOGGER, "Index create fail. param is null.");
            return false;
        }
        int threadNum = IndexConfigHandler.getThreadNum(libBaseDo.getIndexConfigDo());
        this.initCommonRes(threadNum);
        this.initBloomFilter(libBaseDo);
        this.initIndexManager(libBaseDo, threadNum);
        this.createIndexVersionInfo(libBaseDo);
        this.createIndex(libBaseDo);
        boolean exit = this.releaseRes(threadNum);
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Index create end.");
        return exit;
    }

    protected abstract void createIndexVersionInfo(LibBaseDo var1);

    protected abstract void initBloomFilter(LibBaseDo var1);

    protected abstract void initIndexManager(LibBaseDo var1, int var2);

    protected abstract void createIndex(LibBaseDo var1);

    protected boolean releaseRes(int threadNum) {
        boolean exit = this.semaphoreHandler.waitFor(threadNum);
        List<Runnable> unfinishedThreads = this.threadPool.shutdownNow();
        if (CollectionUtils.isNotEmpty(unfinishedThreads)) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Exist unfinished thread, Index create not property.");
            exit = false;
        }
        if (this.indexInfoManagerHandler != null) {
            this.indexInfoManagerHandler.close();
        }
        return exit;
    }

    private void initCommonRes(int threadNum) {
        this.threadPool = new ThreadPoolExecutor(threadNum, threadNum, 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(20), (ThreadFactory)new NamedThreadFactory("Index-thread-pool"));
        this.semaphoreHandler = new SemaphoreHandler(threadNum);
    }
}

