/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.template;

import com.huawei.support.icscbb.commonsearch.index.bloom.HdxBloomFilterHandler;
import com.huawei.support.icscbb.commonsearch.index.chain.CpuControlChain;
import com.huawei.support.icscbb.commonsearch.index.chain.HandlerChain;
import com.huawei.support.icscbb.commonsearch.index.chain.HdxIndexProcessChain;
import com.huawei.support.icscbb.commonsearch.index.chain.HdxIndexedFilterChain;
import com.huawei.support.icscbb.commonsearch.index.chain.HdxVerifyFilterChain;
import com.huawei.support.icscbb.commonsearch.index.chain.IndexPrepareChain;
import com.huawei.support.icscbb.commonsearch.index.config.IndexConfigHandler;
import com.huawei.support.icscbb.commonsearch.index.entity.HdxLibDo;
import com.huawei.support.icscbb.commonsearch.index.entity.IndexConfigDo;
import com.huawei.support.icscbb.commonsearch.index.entity.LibBaseDo;
import com.huawei.support.icscbb.commonsearch.index.listener.impl.HdxMd5TopicHandler;
import com.huawei.support.icscbb.commonsearch.index.listener.impl.HdxNaviTopicHandler;
import com.huawei.support.icscbb.commonsearch.index.manager.HdxIndexManagerHandler;
import com.huawei.support.icscbb.commonsearch.index.template.DefaultIndexTemplate;
import com.huawei.support.icscbb.commonsearch.index.template.event.TopicEventListener;
import com.huawei.support.icscbb.commonsearch.index.template.help.IndexInfoManagerHandler;
import com.huawei.support.icscbb.commonsearch.index.util.IndexFileUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.xml.EventListener;
import com.huawei.support.icscbb.util.xml.context.ParserContext;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import com.huawei.support.icscbb.util.xml.sax.XmlSaxParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HdxIndexTemplate
extends DefaultIndexTemplate {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(HdxIndexTemplate.class);
    private final HdxBloomFilterHandler hdxBloomFilterHandler = new HdxBloomFilterHandler();
    private final HdxIndexManagerHandler hdxIndexManagerHandler = new HdxIndexManagerHandler();
    private int topicAmount;

    @Override
    protected void initBloomFilter(LibBaseDo libBaseDo) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Init BloomFilter.");
        HdxLibDo hdxLibDo = (HdxLibDo)libBaseDo;
        this.hdxBloomFilterHandler.init(libBaseDo);
        this.topicAmount = this.normalNaviXmlTopic(hdxLibDo);
    }

    private int normalNaviXmlTopic(HdxLibDo hdxLibDo) {
        String naviXmlPath = hdxLibDo.getIndexDir() + File.separator + "navi.xml";
        IndexFileUtils.write(naviXmlPath, "<?xml version=\"1.0\" encoding=\"UTF-8\"?><topics>", false);
        ParserContext parserContext = new ParserContext().add("path", (Object)hdxLibDo.getPath()).add("savePath", (Object)naviXmlPath);
        HdxNaviTopicHandler hdxNaviTopicHandler = new HdxNaviTopicHandler(this.hdxBloomFilterHandler);
        hdxNaviTopicHandler.createNewTopic(parserContext);
        int topicNum = hdxNaviTopicHandler.getTopicCount();
        parserContext.add("libId", (Object)hdxLibDo.getLibId());
        parserContext.add("libVersion", (Object)hdxLibDo.getLibV());
        HdxMd5TopicHandler hdxMd5TopicHandler = new HdxMd5TopicHandler(this.hdxBloomFilterHandler);
        hdxMd5TopicHandler.createNewTopic(parserContext);
        IndexFileUtils.write(naviXmlPath, "</topics>", true);
        return topicNum += hdxMd5TopicHandler.getTopicCount();
    }

    @Override
    protected void initIndexManager(LibBaseDo libBaseDo, int threadNum) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Init IndexManager.");
        this.hdxIndexManagerHandler.init(libBaseDo, threadNum);
    }

    @Override
    protected void createIndexVersionInfo(LibBaseDo libBaseDo) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Create Index Version Info.");
        HdxLibDo hdxLibDo = (HdxLibDo)libBaseDo;
        this.indexInfoManagerHandler = new IndexInfoManagerHandler(this.topicAmount, hdxLibDo.getIndexLang(), this.hdxIndexManagerHandler, hdxLibDo.getIndexDir());
        this.indexInfoManagerHandler.createVersionInfo();
    }

    @Override
    protected void createIndex(LibBaseDo libBaseDo) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Create Index.");
        HdxLibDo hdxLibDo = (HdxLibDo)libBaseDo;
        String newNaviXmlPath = hdxLibDo.getIndexDir() + File.separator + "navi.xml";
        this.createNaviNewTopicIndex(newNaviXmlPath, hdxLibDo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNaviNewTopicIndex(String newNaviXmlPath, HdxLibDo hdxLibDo) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Hdx parsing new navi.xml,will create index later.");
        TopicEventListener hdxTopicEventListener = new TopicEventListener(this.createHdxChain(hdxLibDo));
        try (FileInputStream naviTopicInputStream = FileUtils.openInputStream((File)FileUtils.getFile((String[])new String[]{newNaviXmlPath}));){
            XmlSaxParser xmlSaxParser = new XmlSaxParser((EventListener)hdxTopicEventListener, new ParserContext());
            SAXParserUtils.parseXml((InputStream)naviTopicInputStream, (DefaultHandler)xmlSaxParser);
        }
        catch (IOException | SAXException e) {
            try {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Hdx parsing new navi.xml occurred sax or io exception error. docId:{0}", (Throwable)e, new Object[]{hdxLibDo.getDocId()});
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{newNaviXmlPath}));
                throw throwable;
            }
            FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{newNaviXmlPath}));
        }
        FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{newNaviXmlPath}));
    }

    private HandlerChain createHdxChain(HdxLibDo hdxLibDo) {
        IndexConfigDo indexConfigDo = hdxLibDo.getIndexConfigDo();
        return new HandlerChain().addChain(new HdxVerifyFilterChain(this.indexInfoManagerHandler)).addChain(new HdxIndexedFilterChain(this.hdxBloomFilterHandler, this.indexInfoManagerHandler)).addChain(this.getHdxIndexProcessChain(hdxLibDo)).addChain(new CpuControlChain(IndexConfigHandler.getCpuSleepTime(indexConfigDo), IndexConfigHandler.getCpuMaxThreshold(indexConfigDo)));
    }

    private IndexPrepareChain getHdxIndexProcessChain(HdxLibDo hdxLibDo) {
        return new HdxIndexProcessChain().setIndexManagerHandler(this.hdxIndexManagerHandler).setThreadPool(this.threadPool).setHdxLibDo(hdxLibDo).setSemaphoreHandler(this.semaphoreHandler).setIndexInfoManagerHandler(this.indexInfoManagerHandler);
    }

    @Override
    protected boolean releaseRes(int permits) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Release Res.");
        boolean exit = super.releaseRes(permits);
        this.hdxIndexManagerHandler.close();
        return exit;
    }
}

