/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.template;

import com.huawei.support.icscbb.commonsearch.index.bloom.IcsBloomFilterHandler;
import com.huawei.support.icscbb.commonsearch.index.chain.CpuControlChain;
import com.huawei.support.icscbb.commonsearch.index.chain.HandlerChain;
import com.huawei.support.icscbb.commonsearch.index.chain.IndexPrepareChain;
import com.huawei.support.icscbb.commonsearch.index.chain.IndexProcessChain;
import com.huawei.support.icscbb.commonsearch.index.chain.IndexedFilterChain;
import com.huawei.support.icscbb.commonsearch.index.chain.VerifyFilterChain;
import com.huawei.support.icscbb.commonsearch.index.config.IndexConfigHandler;
import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsLibDo;
import com.huawei.support.icscbb.commonsearch.index.entity.IndexConfigDo;
import com.huawei.support.icscbb.commonsearch.index.entity.LibBaseDo;
import com.huawei.support.icscbb.commonsearch.index.entity.MetaExtDo;
import com.huawei.support.icscbb.commonsearch.index.listener.impl.PidHandler;
import com.huawei.support.icscbb.commonsearch.index.listener.impl.PidMetaHandler;
import com.huawei.support.icscbb.commonsearch.index.listener.impl.TopicMetaHandler;
import com.huawei.support.icscbb.commonsearch.index.manager.IcsIndexManagerHandler;
import com.huawei.support.icscbb.commonsearch.index.template.DefaultIndexTemplate;
import com.huawei.support.icscbb.commonsearch.index.template.event.TopicEventListener;
import com.huawei.support.icscbb.commonsearch.index.template.help.DocNaviFacade;
import com.huawei.support.icscbb.commonsearch.index.template.help.IndexInfoManagerHandler;
import com.huawei.support.icscbb.commonsearch.index.util.IndexDirHelper;
import com.huawei.support.icscbb.commonsearch.index.util.IndexFileUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.xml.EventListener;
import com.huawei.support.icscbb.util.xml.context.ParserContext;
import com.huawei.support.icscbb.util.xml.sax.SAXParserUtils;
import com.huawei.support.icscbb.util.xml.sax.XmlSaxParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IcsIndexTemplate
extends DefaultIndexTemplate {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IcsIndexTemplate.class);
    private final IcsBloomFilterHandler icsBloomFilterHandler = new IcsBloomFilterHandler();
    private final IcsIndexManagerHandler icsIndexManagerHandler = new IcsIndexManagerHandler();
    private final PidMetaHandler pidMetaHandler = new PidMetaHandler();
    private final TopicMetaHandler topicMetaHandler = new TopicMetaHandler();
    private HwIcsLibDo hwIcsLibDo;

    @Override
    protected void initBloomFilter(LibBaseDo libBaseDo) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Init BloomFilter.");
        this.icsBloomFilterHandler.init(libBaseDo);
    }

    @Override
    protected void initIndexManager(LibBaseDo libBaseDo, int threadNum) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Init IndexManager.");
        this.icsIndexManagerHandler.init(libBaseDo, threadNum);
    }

    @Override
    protected void createIndexVersionInfo(LibBaseDo libBaseDo) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Create Index Version Info.");
        HwIcsLibDo icsLibDo = (HwIcsLibDo)libBaseDo;
        String indexRootDir = icsLibDo.getIndexDir() + IndexDirHelper.getSubIndexDir(icsLibDo.getDocId(), icsLibDo.getSoftVersion(), icsLibDo.getTaskType());
        this.indexInfoManagerHandler = new IndexInfoManagerHandler(icsLibDo.getPids().size(), icsLibDo.getIndexLang(), this.icsIndexManagerHandler, indexRootDir);
        this.indexInfoManagerHandler.createVersionInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void createIndex(LibBaseDo libBaseDo) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Create Index.");
        this.hwIcsLibDo = (HwIcsLibDo)libBaseDo;
        this.pidMetaHandler.init(this.hwIcsLibDo);
        this.topicMetaHandler.init(this.hwIcsLibDo);
        List<String> pidList = this.hwIcsLibDo.getPids();
        DocNaviFacade.createDocNavIndex(this.icsIndexManagerHandler, this.hwIcsLibDo, this.pidMetaHandler);
        String pidTempDir = this.hwIcsLibDo.getIndexDir() + File.separator + "mapper" + File.separator;
        for (String pid : pidList) {
            Optional<MetaExtDo> metaExtDo;
            String pidTempPath;
            block20: {
                pidTempPath = pidTempDir + pid + ".xml";
                metaExtDo = this.pidMetaHandler.queryExtMetaDo(this.hwIcsLibDo, pid);
                if (metaExtDo.isPresent()) break block20;
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Not find pid[{0}] in lib.", new Object[]{pid});
                this.indexInfoManagerHandler.update();
                FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{pidTempDir}));
                continue;
            }
            try {
                this.normalizePidMapper(pid, metaExtDo.get(), pidTempPath);
                try (FileInputStream inputStream = FileUtils.openInputStream((File)FileUtils.getFile((String[])new String[]{pidTempPath}));){
                    XmlSaxParser xmlSaxParser = new XmlSaxParser((EventListener)new TopicEventListener(this.createChain(libBaseDo.getIndexConfigDo())), new ParserContext());
                    SAXParserUtils.parseXml((InputStream)inputStream, (DefaultHandler)xmlSaxParser);
                }
                this.indexInfoManagerHandler.update();
            }
            catch (IOException | SAXException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Pid[{0}] parse error.", (Throwable)e, new Object[]{pid});
                this.indexInfoManagerHandler.update();
                FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{pidTempDir}));
                continue;
            }
            catch (Exception e2) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Create index error. pid[{0}]", (Throwable)e2, new Object[]{pid});
                this.indexInfoManagerHandler.update();
                {
                    catch (Throwable throwable) {
                        this.indexInfoManagerHandler.update();
                        FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{pidTempDir}));
                        throw throwable;
                    }
                }
                FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{pidTempDir}));
                continue;
            }
            FileUtils.deleteQuietly((File)FileUtils.getFile((String[])new String[]{pidTempDir}));
        }
    }

    @Override
    protected boolean releaseRes(int threadNum) {
        CodeCCUtils.INSTANCE.infoLog(LOGGER, "Release Res.");
        boolean exit = super.releaseRes(threadNum);
        this.icsIndexManagerHandler.close();
        return exit;
    }

    private void normalizePidMapper(String pid, MetaExtDo metaExtDo, String pidTempPath) {
        IndexFileUtils.write(pidTempPath, "<?xml version=\"1.0\" encoding=\"UTF-8\"?><topics>", false);
        int inc = StringUtils.equals((CharSequence)metaExtDo.getDocId(), (CharSequence)this.hwIcsLibDo.getDocId()) ? 0 : 1;
        ParserContext parseContext = new ParserContext().add("docId", (Object)metaExtDo.getDocId()).add("refDocId", (Object)metaExtDo.getDocId()).add("parentDocIds", (Object)metaExtDo.getDocId()).add("curPid", (Object)pid).add("path", (Object)metaExtDo.getPath()).add("savePath", (Object)pidTempPath).add("layer", (Object)0).add("parentPid", (Object)pid).add("inc", (Object)inc);
        new PidHandler().setPidMetaHandler(this.pidMetaHandler).setTopicMetaHandler(this.topicMetaHandler).setHwIcsLibDo(this.hwIcsLibDo).createNewPid(parseContext);
        IndexFileUtils.write(pidTempPath, "</topics>", true);
    }

    private HandlerChain createChain(IndexConfigDo indexConfigDo) {
        return new HandlerChain().addChain(new IndexedFilterChain(this.icsBloomFilterHandler)).addChain(new VerifyFilterChain(this.hwIcsLibDo.getTaskType(), this.topicMetaHandler)).addChain(this.getIndexProcessChain()).addChain(new CpuControlChain(IndexConfigHandler.getCpuSleepTime(indexConfigDo), IndexConfigHandler.getCpuMaxThreshold(indexConfigDo)));
    }

    private IndexPrepareChain getIndexProcessChain() {
        return new IndexProcessChain().setIndexManagerHandler(this.icsIndexManagerHandler).setThreadPool(this.threadPool).setPidMetaHandler(this.pidMetaHandler).setTopicMetaHandler(this.topicMetaHandler).setHwIcsLibDo(this.hwIcsLibDo).setSemaphoreHandler(this.semaphoreHandler);
    }
}

