/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.template.help;

import com.huawei.support.icscbb.commonsearch.index.entity.HwIcsLibDo;
import com.huawei.support.icscbb.commonsearch.index.listener.impl.DocNaviHandler;
import com.huawei.support.icscbb.commonsearch.index.listener.impl.PidMetaHandler;
import com.huawei.support.icscbb.commonsearch.index.manager.IcsIndexManagerHandler;
import com.huawei.support.icscbb.commonsearch.lucene.index.dto.FieldInfoDto;
import com.huawei.support.icscbb.commonsearch.lucene.index.exception.IndexException;
import com.huawei.support.icscbb.commonsearch.lucene.index.service.IndexManager;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import java.util.Optional;

public class DocNaviFacade {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(DocNaviFacade.class);
    private static final int MAX_DOCNAVI_NUM = 6;

    public static void createDocNavIndex(IcsIndexManagerHandler icsIndexManagerHandler, HwIcsLibDo hwIcsLibDo, PidMetaHandler pidMetaHandler) {
        Optional<IndexManager> indexManagerOpt = DocNaviFacade.getIndexManager(icsIndexManagerHandler, hwIcsLibDo.getDocId());
        if (!indexManagerOpt.isPresent()) {
            return;
        }
        IndexManager indexManager = indexManagerOpt.get();
        DocNaviFacade.deleteOldDocNavIndex(indexManager, hwIcsLibDo);
        DocNaviFacade.deleteOldPidNameIndex(indexManager, hwIcsLibDo);
        for (int num = 0; num < 6; ++num) {
            DocNaviHandler docNaviHandler = new DocNaviHandler(pidMetaHandler, indexManager, hwIcsLibDo);
            String docNavId = "docnav" + (num == 0 ? "" : String.valueOf(num));
            docNaviHandler.parser(docNavId);
        }
        try {
            indexManager.commit();
        }
        catch (IndexException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "DocNav index commit fail.", (Throwable)e);
        }
        icsIndexManagerHandler.add(hwIcsLibDo.getDocId(), indexManager);
    }

    private static Optional<IndexManager> getIndexManager(IcsIndexManagerHandler icsIndexManagerHandler, String docId) {
        IndexManager indexManager = null;
        try {
            indexManager = icsIndexManagerHandler.get(docId);
        }
        catch (InterruptedException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Not get index manager.", (Throwable)e);
        }
        return Optional.ofNullable(indexManager);
    }

    private static void deleteOldDocNavIndex(IndexManager indexManager, HwIcsLibDo hwIcsLibDo) {
        FieldInfoDto fieldInfoDto = new FieldInfoDto("type", "docNav");
        try {
            indexManager.deleteIndex(fieldInfoDto, hwIcsLibDo.getIndexLang());
        }
        catch (IndexException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Delete docNav index fail.", (Throwable)e);
        }
    }

    private static void deleteOldPidNameIndex(IndexManager indexManager, HwIcsLibDo hwIcsLibDo) {
        FieldInfoDto fieldInfoDto = new FieldInfoDto("type", "pid");
        try {
            indexManager.deleteIndex(fieldInfoDto, hwIcsLibDo.getIndexLang());
        }
        catch (IndexException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Delete pidName index fail.", (Throwable)e);
        }
    }
}

