/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.support.icscbb.commonsearch.index.template.help;

import com.huawei.support.icscbb.commonsearch.index.manager.IndexManagerHandler;
import com.huawei.support.icscbb.commonsearch.lucene.index.exception.IndexException;
import com.huawei.support.icscbb.commonsearch.lucene.index.service.IndexManager;
import com.huawei.support.icscbb.commonsearch.lucene.index.util.IndexUtils;
import com.huawei.support.icscbb.log.common.service.CodeCCUtils;
import com.huawei.support.icscbb.log.lite.adapter.CommonLogger;
import com.huawei.support.icscbb.log.lite.adapter.CommonLoggerFactory;
import com.huawei.support.icscbb.util.date.DateUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;

public class IndexInfoManagerHandler {
    private static final CommonLogger LOGGER = CommonLoggerFactory.getLogger(IndexInfoManagerHandler.class);
    private static final Object LOCK_OBJ = new Object();
    private static final int FINISHED_PROGRESS = 100;
    private static final int DIVIDE_SCALE = 5;
    private static final int THRESHOLD_DIVIDED = 10;
    private static final String DEFAULT_PROGRESS = "0";
    private static final String PROGRESS_DEFAULT_MIN = "0.01";
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private final int threshold;
    private final int docNums;
    private final String indexLang;
    private final IndexManagerHandler indexManagerHandler;
    private IndexManager indexManager;
    private volatile int count;

    public IndexInfoManagerHandler(int docNums, String indexLang, IndexManagerHandler indexManagerHandler, String indexRootDir) {
        this.threshold = docNums < 10 ? docNums : docNums / 10;
        this.docNums = docNums;
        this.indexLang = indexLang;
        this.indexManagerHandler = indexManagerHandler;
        try {
            this.indexManager = new IndexManager(indexLang, indexRootDir, false);
        }
        catch (IndexException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Init index writer error.", (Throwable)e);
        }
    }

    public void createVersionInfo() {
        this.addDocument(this.getVersionInfoDoc(DEFAULT_PROGRESS));
        this.commit();
    }

    public void addDocument(Document document) {
        try {
            this.indexManager.addDocument(document);
        }
        catch (IndexException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Index document add error.", (Throwable)e);
        }
    }

    private void commit() {
        try {
            this.indexManager.commit();
        }
        catch (IndexException e) {
            CodeCCUtils.INSTANCE.errorLog(LOGGER, "Index commit error.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object = LOCK_OBJ;
        synchronized (object) {
            ++this.count;
            if (!this.isNeedUpdate()) {
                return;
            }
            try {
                this.indexManager.updateIndex("indexinfo_id", "2022", this.getVersionInfoDoc(this.getProgress()));
                this.indexManager.commit();
                this.indexManagerHandler.commit();
            }
            catch (IndexException e) {
                CodeCCUtils.INSTANCE.errorLog(LOGGER, "Index progress update error.", (Throwable)e);
            }
        }
    }

    public void close() {
        if (this.indexManager != null) {
            this.indexManager.close();
        }
    }

    private Document getVersionInfoDoc(String progress) {
        Document document = new Document();
        document.add((IndexableField)IndexUtils.getField("progress", progress, Field.Store.YES, TextField.class.getSimpleName()));
        document.add((IndexableField)IndexUtils.getField("version", this.getIndexVersion(this.indexLang), Field.Store.YES, TextField.class.getSimpleName()));
        document.add((IndexableField)IndexUtils.getField("indexinfo_id", "2022", Field.Store.YES, TextField.class.getSimpleName()));
        document.add((IndexableField)IndexUtils.getField("indexLang", this.indexLang, Field.Store.YES, TextField.class.getSimpleName()));
        document.add((IndexableField)IndexUtils.getField("subversion", this.getIndexSubVersion(this.indexLang), Field.Store.YES, TextField.class.getSimpleName()));
        document.add((IndexableField)IndexUtils.getField("createtime", DateUtils.getCurrentDateStr(), Field.Store.YES, TextField.class.getSimpleName()));
        return document;
    }

    private String getIndexVersion(String indexLang) {
        return StringUtils.equalsIgnoreCase((CharSequence)indexLang, (CharSequence)"zh") ? "4.0" : "4.0";
    }

    private String getIndexSubVersion(String indexLang) {
        return StringUtils.equalsIgnoreCase((CharSequence)indexLang, (CharSequence)"zh") ? "3.1" : "2.1";
    }

    private String getProgress() {
        double progressD = new BigDecimal(this.count).divide(new BigDecimal(this.docNums), 5, RoundingMode.UP).multiply(new BigDecimal(100)).doubleValue();
        String progress = NUMBER_FORMAT.format(progressD);
        return StringUtils.equals((CharSequence)progress, (CharSequence)DEFAULT_PROGRESS) ? PROGRESS_DEFAULT_MIN : progress;
    }

    private boolean isNeedUpdate() {
        return this.count % this.threshold == 0 || this.count == this.docNums;
    }

    static {
        NUMBER_FORMAT.setMaximumFractionDigits(2);
    }
}

